/*
 * Decompiled with CFR 0.152.
 */
package shadows.endertweaker;

import com.enderio.core.common.util.NNList;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crazypants.enderio.base.recipe.IManyToOneRecipe;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.alloysmelter.AlloyRecipeManager;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import shadows.endertweaker.EnderTweaker;
import shadows.endertweaker.RecipeUtils;
import shadows.endertweaker.recipe.ManyToOneRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.enderio.AlloySmelter")
@ZenRegister
public class AlloySmelter {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] input, @Optional int energyCost, @Optional float xp) {
        if (AlloySmelter.hasErrors(output, input)) {
            return;
        }
        EnderTweaker.ADDITIONS.add(() -> {
            RecipeOutput out = new RecipeOutput(CraftTweakerMC.getItemStack((IItemStack)output), 1.0f, xp);
            ManyToOneRecipe rec = new ManyToOneRecipe(out, energyCost, RecipeBonusType.NONE, RecipeUtils.toEIOInputs(input));
            AlloyRecipeManager.getInstance().addRecipe((Recipe)rec);
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output == null) {
            CraftTweakerAPI.logError((String)"Cannot remove recipe for null from alloy smelter.");
            return;
        }
        EnderTweaker.REMOVALS.add(() -> {
            ItemStack stack = CraftTweakerMC.getItemStack((IItemStack)output);
            ArrayList<IManyToOneRecipe> removals = new ArrayList<IManyToOneRecipe>();
            for (IManyToOneRecipe r : AlloyRecipeManager.getInstance().getRecipes()) {
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)r.getOutput(), (boolean)false)) continue;
                removals.add(r);
            }
            if (!removals.isEmpty()) {
                removals.forEach(arg_0 -> AlloyRecipeManager.getInstance().getRecipes().remove(arg_0));
            } else {
                CraftTweakerAPI.logError((String)("No Alloy Smelter recipe found for " + output.getDisplayName()));
            }
        });
    }

    @ZenMethod
    public static void removeByInputs(IItemStack ... input) {
        if (input == null || input.length > 3) {
            CraftTweakerAPI.logError((String)"Cannot remove recipe for null from alloy smelter.");
            return;
        }
        EnderTweaker.REMOVALS.add(() -> {
            NNList inputs = new NNList();
            for (int i = 0; i < input.length; ++i) {
                inputs.add((Object)new MachineRecipeInput(i, CraftTweakerMC.getItemStack((IItemStack)input[i])));
            }
            IRecipe r = AlloyRecipeManager.getInstance().getRecipeForInputs(RecipeLevel.IGNORE, inputs);
            if (r != null) {
                AlloyRecipeManager.getInstance().getRecipes().remove((Object)r);
            } else {
                CraftTweakerAPI.logError((String)("No Alloy Smelter recipe found for " + RecipeUtils.getDisplayString((IIngredient[])input)));
            }
        });
    }

    public static boolean hasErrors(IItemStack output, IIngredient[] input) {
        if (output == null || output.isEmpty()) {
            CraftTweakerAPI.logError((String)("Invalid output (empty or null) in Alloy Smelter recipe: " + output));
            return true;
        }
        if (input.length > 3) {
            CraftTweakerAPI.logError((String)("Invalid Alloy Smelter input, must be between 1 and 3 inputs.  Provided: " + RecipeUtils.getDisplayString(input)));
            return true;
        }
        return false;
    }
}

