/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import java.util.LinkedList;
import java.util.List;
import logisticspipes.items.ItemModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.guis.pipe.ChassiGuiProvider;
import logisticspipes.network.packets.chassis.ChassisGUI;
import logisticspipes.network.packets.gui.OpenUpgradePacket;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.upgrades.ModuleUpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiChassiPipe
extends LogisticsBaseGuiScreen {
    private final PipeLogisticsChassi _chassiPipe;
    private final IInventory _moduleInventory;
    private final List<SmallGuiButton> moduleConfigButtons = new LinkedList<SmallGuiButton>();
    private final Slot[] upgradeslot = new Slot[16];
    private GuiButton[] upgradeConfig = new GuiButton[16];
    private boolean hasUpgradeModuleUpgarde;

    public GuiChassiPipe(EntityPlayer player, PipeLogisticsChassi chassi, boolean hasUpgradeModuleUpgarde) {
        super(null);
        this._chassiPipe = chassi;
        this._moduleInventory = chassi.getModuleInventory();
        this.hasUpgradeModuleUpgarde = hasUpgradeModuleUpgarde;
        DummyContainer dummy = new DummyContainer((IInventory)player.field_71071_by, this._moduleInventory);
        if (this._chassiPipe.getChassiSize() < 5) {
            dummy.addNormalSlotsForPlayerInventory(18, 97);
        } else {
            dummy.addNormalSlotsForPlayerInventory(18, 174);
        }
        if (this._chassiPipe.getChassiSize() > 0) {
            dummy.addModuleSlot(0, this._moduleInventory, 19, 9, this._chassiPipe);
        }
        if (this._chassiPipe.getChassiSize() > 1) {
            dummy.addModuleSlot(1, this._moduleInventory, 19, 29, this._chassiPipe);
        }
        if (this._chassiPipe.getChassiSize() > 2) {
            dummy.addModuleSlot(2, this._moduleInventory, 19, 49, this._chassiPipe);
        }
        if (this._chassiPipe.getChassiSize() > 3) {
            dummy.addModuleSlot(3, this._moduleInventory, 19, 69, this._chassiPipe);
        }
        if (this._chassiPipe.getChassiSize() > 4) {
            dummy.addModuleSlot(4, this._moduleInventory, 19, 89, this._chassiPipe);
            dummy.addModuleSlot(5, this._moduleInventory, 19, 109, this._chassiPipe);
            dummy.addModuleSlot(6, this._moduleInventory, 19, 129, this._chassiPipe);
            dummy.addModuleSlot(7, this._moduleInventory, 19, 149, this._chassiPipe);
        }
        if (hasUpgradeModuleUpgarde) {
            for (int i = 0; i < this._chassiPipe.getChassiSize(); ++i) {
                int fI = i;
                ModuleUpgradeManager upgradeManager = this._chassiPipe.getModuleUpgradeManager(i);
                this.upgradeslot[i * 2] = dummy.addUpgradeSlot(0, upgradeManager, 0, 145, 9 + i * 20, itemStack -> ChassiGuiProvider.checkStack(itemStack, this._chassiPipe, fI));
                this.upgradeslot[i * 2 + 1] = dummy.addUpgradeSlot(1, upgradeManager, 1, 165, 9 + i * 20, itemStack -> ChassiGuiProvider.checkStack(itemStack, this._chassiPipe, fI));
            }
        }
        this.field_147002_h = dummy;
        this.field_146999_f = 194;
        this.field_147000_g = 186;
        if (this._chassiPipe.getChassiSize() > 4) {
            this.field_147000_g = 256;
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int left = this.field_146294_l / 2 - this.field_146999_f / 2;
        int top = this.field_146295_m / 2 - this.field_147000_g / 2;
        this.field_146292_n.clear();
        this.moduleConfigButtons.clear();
        this.upgradeConfig = new GuiButton[this._chassiPipe.getChassiSize() * 2];
        for (int i = 0; i < this._chassiPipe.getChassiSize(); ++i) {
            this.moduleConfigButtons.add(this.func_189646_b(new SmallGuiButton(i, left + 5, top + 12 + 20 * i, 10, 10, "!")));
            if (this._moduleInventory == null) continue;
            ItemStack module = this._moduleInventory.func_70301_a(i);
            this.moduleConfigButtons.get((int)i).field_146125_m = module.func_190926_b() || this._chassiPipe.getLogisticsModule().getSubModule(i) == null ? false : this._chassiPipe.getLogisticsModule().getSubModule(i).hasGui();
            if (!this.hasUpgradeModuleUpgarde) continue;
            this.upgradeConfig[i * 2] = this.func_189646_b(new SmallGuiButton(100 + i, this.field_147003_i + 134, this.field_147009_r + 12 + i * 20, 10, 10, "!"));
            this.upgradeConfig[i * 2].field_146125_m = this._chassiPipe.getModuleUpgradeManager(i).hasGuiUpgrade(0);
            this.upgradeConfig[i * 2 + 1] = this.func_189646_b(new SmallGuiButton(120 + i, this.field_147003_i + 182, this.field_147009_r + 12 + i * 20, 10, 10, "!"));
            this.upgradeConfig[i * 2 + 1].field_146125_m = this._chassiPipe.getModuleUpgradeManager(i).hasGuiUpgrade(1);
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        LogisticsModule module;
        if (guibutton.field_146127_k >= 0 && guibutton.field_146127_k <= 7 && (module = this._chassiPipe.getLogisticsModule().getSubModule(guibutton.field_146127_k)) != null) {
            CoordinatesPacket packet = PacketHandler.getPacket(ChassisGUI.class).setButtonID(guibutton.field_146127_k).setPosX(this._chassiPipe.getX()).setPosY(this._chassiPipe.getY()).setPosZ(this._chassiPipe.getZ());
            MainProxy.sendPacketToServer(packet);
        }
        for (int i = 0; i < this.upgradeConfig.length; ++i) {
            if (this.upgradeConfig[i] != guibutton) continue;
            MainProxy.sendPacketToServer(PacketHandler.getPacket(OpenUpgradePacket.class).setSlot(this.upgradeslot[i]));
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        int i;
        super.func_146979_b(par1, par2);
        for (i = 0; i < this._chassiPipe.getChassiSize(); ++i) {
            ItemStack module = this._moduleInventory.func_70301_a(i);
            this.moduleConfigButtons.get((int)i).field_146125_m = module.func_190926_b() || this._chassiPipe.getLogisticsModule().getSubModule(i) == null ? false : this._chassiPipe.getLogisticsModule().getSubModule(i).hasGui();
        }
        if (this.hasUpgradeModuleUpgarde) {
            for (i = 0; i < this.upgradeConfig.length; ++i) {
                this.upgradeConfig[i].field_146125_m = this._chassiPipe.getModuleUpgradeManager(i / 2).hasGuiUpgrade(i % 2);
            }
        }
        if (this._chassiPipe.getChassiSize() > 0) {
            this.field_146297_k.field_71466_p.func_78276_b(this.getModuleName(0), 40, 14, 0x404040);
        }
        if (this._chassiPipe.getChassiSize() > 1) {
            this.field_146297_k.field_71466_p.func_78276_b(this.getModuleName(1), 40, 34, 0x404040);
        }
        if (this._chassiPipe.getChassiSize() > 2) {
            this.field_146297_k.field_71466_p.func_78276_b(this.getModuleName(2), 40, 54, 0x404040);
        }
        if (this._chassiPipe.getChassiSize() > 3) {
            this.field_146297_k.field_71466_p.func_78276_b(this.getModuleName(3), 40, 74, 0x404040);
        }
        if (this._chassiPipe.getChassiSize() > 4) {
            this.field_146297_k.field_71466_p.func_78276_b(this.getModuleName(4), 40, 94, 0x404040);
            this.field_146297_k.field_71466_p.func_78276_b(this.getModuleName(5), 40, 114, 0x404040);
            this.field_146297_k.field_71466_p.func_78276_b(this.getModuleName(6), 40, 134, 0x404040);
            this.field_146297_k.field_71466_p.func_78276_b(this.getModuleName(7), 40, 154, 0x404040);
        }
    }

    private String getModuleName(int slot) {
        if (this._moduleInventory == null) {
            return "";
        }
        if (this._moduleInventory.func_70301_a(slot).func_190926_b()) {
            return "";
        }
        if (!(this._moduleInventory.func_70301_a(slot).func_77973_b() instanceof ItemModule)) {
            return "";
        }
        String name = ((ItemModule)this._moduleInventory.func_70301_a(slot).func_77973_b()).func_77653_i(this._moduleInventory.func_70301_a(slot));
        if (!this.hasUpgradeModuleUpgarde) {
            return name;
        }
        return StringUtils.getWithMaxWidth(name, 100, this.field_146289_q);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this._chassiPipe.getChassiGUITexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.hasUpgradeModuleUpgarde) {
            for (int i = 0; i < this._chassiPipe.getChassiSize(); ++i) {
                GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + 144, this.field_147009_r + 8 + i * 20);
                GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + 164, this.field_147009_r + 8 + i * 20);
            }
        }
    }
}

