/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractguis;

import logisticspipes.network.abstractguis.CoordinatesPopupGuiProvider;
import logisticspipes.network.exception.TargetNotFoundException;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public abstract class UpgradeCoordinatesGuiProvider
extends CoordinatesPopupGuiProvider {
    private int positionInt;

    public UpgradeCoordinatesGuiProvider(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.positionInt);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.positionInt = input.readInt();
    }

    public UpgradeCoordinatesGuiProvider setSlot(Slot slot) {
        this.setPositionInt(slot.field_75222_d);
        return this;
    }

    public <T extends Slot> T getSlot(EntityPlayer player, Class<T> clazz) {
        if (player.field_71070_bA instanceof DummyContainer) {
            if (this.positionInt >= player.field_71070_bA.field_75151_b.size()) {
                this.targetNotFound("The requested Slot was out of range");
            } else {
                Slot slot = player.field_71070_bA.func_75139_a(this.positionInt);
                if (slot == null) {
                    this.targetNotFound("The requested Slot was null");
                } else if (!clazz.isAssignableFrom(slot.getClass())) {
                    this.targetNotFound("Couldn't find " + clazz.getName() + ", found slot with " + slot.getClass());
                } else {
                    return (T)slot;
                }
            }
        }
        return null;
    }

    protected void targetNotFound(String message) {
        throw new TargetNotFoundException(message, this);
    }

    protected int getPositionInt() {
        return this.positionInt;
    }

    private UpgradeCoordinatesGuiProvider setPositionInt(int positionInt) {
        this.positionInt = positionInt;
        return this;
    }
}

