/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.exception;

import java.util.ArrayList;
import java.util.Arrays;
import logisticspipes.LPConstants;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.exception.DelayPacketException;

public class TargetNotFoundException
extends DelayPacketException {
    private static final long serialVersionUID = 8830733712757259675L;

    public TargetNotFoundException(String message, ModernPacket packet) {
        super(message);
        if (!LPConstants.DEBUG) {
            return;
        }
        StackTraceElement[] astacktraceelement = PacketHandler.debugMap.get(packet.getDebugId());
        if (astacktraceelement != null) {
            ArrayList<Object> list = new ArrayList<StackTraceElement>();
            for (StackTraceElement element : this.getStackTrace()) {
                list.add(element);
                if (element.getClassName().equals("logisticspipes.network.PacketHandler")) break;
            }
            list.remove(0);
            this.setStackTrace(list.toArray(new StackTraceElement[0]));
            list = new ArrayList<StackTraceElement>(Arrays.asList(astacktraceelement));
            if (list.size() > 2) {
                list.remove(0);
                list.remove(0);
            }
            RuntimeException runtime = new RuntimeException("Packet was send from: ");
            runtime.setStackTrace(list.toArray(new StackTraceElement[0]));
            this.initCause(runtime);
        }
    }

    public TargetNotFoundException(String message, GuiProvider packet) {
        super(message);
    }
}

