/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.gui;

import logisticspipes.asm.ClientSideOnlyMethodContent;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class OpenGUIPacket
extends ModernPacket {
    private int guiID;
    private int windowID;
    private byte[] guiData;

    public OpenGUIPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.guiID = input.readInt();
        this.windowID = input.readInt();
        this.guiData = input.readByteArray();
    }

    @Override
    @ClientSideOnlyMethodContent
    public void processPacket(EntityPlayer player) {
        NewGuiHandler.openGui(this, player);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeInt(this.guiID);
        output.writeInt(this.windowID);
        output.writeByteArray(this.guiData);
    }

    @Override
    public ModernPacket template() {
        return new OpenGUIPacket(this.getId());
    }

    public int getGuiID() {
        return this.guiID;
    }

    public OpenGUIPacket setGuiID(int guiID) {
        this.guiID = guiID;
        return this;
    }

    public int getWindowID() {
        return this.windowID;
    }

    public OpenGUIPacket setWindowID(int windowID) {
        this.windowID = windowID;
        return this;
    }

    public byte[] getGuiData() {
        return this.guiData;
    }

    public OpenGUIPacket setGuiData(byte[] guiData) {
        this.guiData = guiData;
        return this;
    }
}

