/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.modules.ModuleActiveSupplier;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.CapabilityItemHandler;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SlotFinderNumberPacket
extends ModuleCoordinatesPacket {
    private int pipePosX;
    private int pipePosY;
    private int pipePosZ;
    private int inventorySlot;
    private int slot;

    public SlotFinderNumberPacket(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new SlotFinderNumberPacket(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        TileEntity inv = this.getTile(player.field_70170_p, (TileEntity tile) -> tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        IInventoryUtil util = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv, null);
        Slot result = null;
        if (((Slot)player.field_71070_bA.field_75151_b.get((int)this.inventorySlot)).field_75222_d == this.inventorySlot) {
            result = (Slot)player.field_71070_bA.field_75151_b.get(this.inventorySlot);
        }
        if (result == null) {
            for (Slot slotObject : player.field_71070_bA.field_75151_b) {
                if (slotObject.field_75222_d != this.inventorySlot) continue;
                result = slotObject;
                break;
            }
        }
        if (result == null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.slotnotfound", new Object[0]));
            return;
        }
        int resultIndex = -1;
        ItemStack content = result.func_75211_c();
        if (!content.func_190926_b()) {
            for (int i = 0; i < util.getSizeInventory(); ++i) {
                if (content != util.getStackInSlot(i)) continue;
                resultIndex = i;
                break;
            }
        } else {
            int i;
            ItemStack dummyStack = new ItemStack(Blocks.field_150348_b, 0, 0);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("LPStackFinderBoolean", true);
            dummyStack.func_77982_d(nbt);
            result.func_75215_d(dummyStack);
            for (i = 0; i < util.getSizeInventory(); ++i) {
                if (dummyStack != util.getStackInSlot(i)) continue;
                resultIndex = i;
                break;
            }
            if (resultIndex == -1) {
                for (i = 0; i < util.getSizeInventory(); ++i) {
                    ItemStack stack = util.getStackInSlot(i);
                    if (stack.func_190926_b() || !ItemIdentifier.get(stack).equals(ItemIdentifier.get(dummyStack)) || stack.func_190916_E() != dummyStack.func_190916_E()) continue;
                    resultIndex = i;
                    break;
                }
            }
            result.func_75215_d(ItemStack.field_190927_a);
        }
        if (resultIndex == -1) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.slotnotfound", new Object[0]));
        } else {
            this.setPosX(this.getPipePosX());
            this.setPosY(this.getPipePosY());
            this.setPosZ(this.getPipePosZ());
            ModuleActiveSupplier module = this.getLogisticsModule(player, ModuleActiveSupplier.class);
            if (module != null) {
                module.slotArray[this.slot] = resultIndex;
            }
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeInt(this.inventorySlot);
        output.writeInt(this.slot);
        output.writeInt(this.pipePosX);
        output.writeInt(this.pipePosY);
        output.writeInt(this.pipePosZ);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.inventorySlot = input.readInt();
        this.slot = input.readInt();
        this.pipePosX = input.readInt();
        this.pipePosY = input.readInt();
        this.pipePosZ = input.readInt();
    }

    public int getPipePosX() {
        return this.pipePosX;
    }

    public SlotFinderNumberPacket setPipePosX(int pipePosX) {
        this.pipePosX = pipePosX;
        return this;
    }

    public int getPipePosY() {
        return this.pipePosY;
    }

    public SlotFinderNumberPacket setPipePosY(int pipePosY) {
        this.pipePosY = pipePosY;
        return this;
    }

    public int getPipePosZ() {
        return this.pipePosZ;
    }

    public SlotFinderNumberPacket setPipePosZ(int pipePosZ) {
        this.pipePosZ = pipePosZ;
        return this;
    }

    public SlotFinderNumberPacket setInventorySlot(int inventorySlot) {
        this.inventorySlot = inventorySlot;
        return this;
    }

    public int getSlot() {
        return this.slot;
    }

    public SlotFinderNumberPacket setSlot(int slot) {
        this.slot = slot;
        return this;
    }
}

