/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.routingdebug;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.debug.ClientViewController;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;

@StaticResolve
public class RoutingUpdateDebugFilters
extends ModernPacket {
    private DoubleCoordinates pos;
    private EnumMap<PipeRoutingConnectionType, List<List<IFilter>>> filters;
    private EnumMap<PipeRoutingConnectionType, List<List<DoubleCoordinates>>> filterPositions;

    public RoutingUpdateDebugFilters(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        short id;
        this.pos = new DoubleCoordinates(input);
        this.filterPositions = new EnumMap(PipeRoutingConnectionType.class);
        while ((id = input.readShort()) != -1) {
            int length;
            PipeRoutingConnectionType type = PipeRoutingConnectionType.values[id];
            ArrayList typeFilters = new ArrayList();
            while ((length = input.readShort()) != -1) {
                ArrayList<DoubleCoordinates> linkedFilter = new ArrayList<DoubleCoordinates>();
                for (int i = 0; i < length; ++i) {
                    linkedFilter.add(new DoubleCoordinates(input));
                }
                typeFilters.add(linkedFilter);
            }
            this.filterPositions.put(type, typeFilters);
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ClientViewController.instance().handlePacket(this);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeSerializable(this.pos);
        for (PipeRoutingConnectionType type : this.filters.keySet()) {
            output.writeShort(type.ordinal());
            for (List<IFilter> linkedFilter : this.filters.get((Object)type)) {
                output.writeShort(linkedFilter.size());
                for (IFilter filter : linkedFilter) {
                    output.writeSerializable(filter.getLPPosition());
                }
            }
            output.writeShort(-1);
        }
        output.writeShort(-1);
    }

    @Override
    public ModernPacket template() {
        return new RoutingUpdateDebugFilters(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public DoubleCoordinates getPos() {
        return this.pos;
    }

    public RoutingUpdateDebugFilters setPos(DoubleCoordinates pos) {
        this.pos = pos;
        return this;
    }

    public RoutingUpdateDebugFilters setFilters(EnumMap<PipeRoutingConnectionType, List<List<IFilter>>> filters) {
        this.filters = filters;
        return this;
    }

    public EnumMap<PipeRoutingConnectionType, List<List<DoubleCoordinates>>> getFilterPositions() {
        return this.filterPositions;
    }
}

