/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import logisticspipes.LPBlocks;
import logisticspipes.items.ItemLogisticsPipe;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.I3DOperation;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.interfaces.TextureTransformation;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.proxy.object3d.operation.LPUVScale;
import logisticspipes.proxy.object3d.operation.LPUVTransformationList;
import logisticspipes.renderer.LogisticsRenderPipe;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.renderer.newpipe.LogisticsNewSolidBlockWorldRenderer;
import logisticspipes.renderer.newpipe.RenderEntry;
import logisticspipes.renderer.state.PipeRenderState;
import logisticspipes.textures.Textures;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class LogisticsNewPipeModel
implements IModel {
    private static final ResourceLocation BASE_TEXTURE = new ResourceLocation("logisticspipes", "blocks/blank_pipe");
    public static TextureAtlasSprite BASE_TEXTURE_SPRITE;
    public static TextureTransformation BASE_TEXTURE_TRANSFORM;
    public static Map<ModelResourceLocation, CoreUnroutedPipe> nameTextureIdMap;
    private ModelResourceLocation key;

    public static void registerTextures(TextureMap iconRegister) {
        BASE_TEXTURE_SPRITE = iconRegister.func_174942_a(BASE_TEXTURE);
        if (BASE_TEXTURE_TRANSFORM == null) {
            BASE_TEXTURE_TRANSFORM = SimpleServiceLocator.cclProxy.createIconTransformer(BASE_TEXTURE_SPRITE);
        } else {
            BASE_TEXTURE_TRANSFORM.update(BASE_TEXTURE_SPRITE);
        }
    }

    public LogisticsNewPipeModel(ModelResourceLocation resource) {
        this.key = resource;
    }

    @Nonnull
    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    @Nonnull
    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IBakedModel bake(@Nonnull IModelState state, final @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        final ArrayList quads = Lists.newArrayList();
        return new IBakedModel(){

            @SideOnly(value=Side.CLIENT)
            @Nonnull
            public List<BakedQuad> func_188616_a(@Nullable IBlockState blockstate, @Nullable EnumFacing side, long rand) {
                List<BakedQuad> result = Collections.emptyList();
                BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
                if (layer == BlockRenderLayer.CUTOUT || layer == null || blockstate == null) {
                    result = this.getLPQuads(blockstate, side);
                }
                return this.addOtherQuads(result, blockstate, side, rand);
            }

            private List<BakedQuad> addOtherQuads(List<BakedQuad> list, IBlockState blockstate, EnumFacing side, long rand) {
                if (blockstate != null) {
                    return SimpleServiceLocator.mcmpProxy.addQuads(list, blockstate, side, rand);
                }
                return list;
            }

            private List<BakedQuad> getLPQuads(@Nullable IBlockState blockstate, @Nullable EnumFacing side) {
                if (blockstate != null) {
                    if (side == null) {
                        Object localQuads;
                        IExtendedBlockState eState = (IExtendedBlockState)blockstate;
                        Cache objectCache = (Cache)eState.getValue((IUnlistedProperty)LogisticsBlockGenericPipe.propertyCache);
                        if (objectCache != null && (localQuads = objectCache.getIfPresent((Object)PipeRenderState.LocalCacheType.QUADS)) instanceof List) {
                            return (List)localQuads;
                        }
                        List<BakedQuad> newLocalQuads = LogisticsRenderPipe.secondRenderer.getQuadsFromRenderList(LogisticsNewPipeModel.this.generatePipeRenderList(blockstate), format, true);
                        if (objectCache != null) {
                            objectCache.put((Object)PipeRenderState.LocalCacheType.QUADS, newLocalQuads);
                        }
                        return newLocalQuads;
                    }
                } else {
                    if (quads.isEmpty()) {
                        quads.addAll(LogisticsRenderPipe.secondRenderer.getQuadsFromRenderList(LogisticsNewPipeModel.this.generatePipeRenderList(), format, true));
                    }
                    return quads;
                }
                return Collections.emptyList();
            }

            public boolean func_177555_b() {
                return false;
            }

            public boolean func_177556_c() {
                return true;
            }

            public boolean func_188618_c() {
                return false;
            }

            @Nonnull
            public TextureAtlasSprite func_177554_e() {
                return BASE_TEXTURE_SPRITE;
            }

            @Nonnull
            public ItemOverrideList func_188617_f() {
                return ItemOverrideList.field_188022_a;
            }

            @Nonnull
            public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
                return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)SimpleServiceLocator.cclProxy.getDefaultBlockState(), (ItemCameraTransforms.TransformType)cameraTransformType);
            }
        };
    }

    private List<RenderEntry> generatePipeRenderList(IBlockState blockstate) {
        List<RenderEntry> objectsToRender = new ArrayList<RenderEntry>();
        if (blockstate.func_177229_b(LogisticsBlockGenericPipe.modelTypeProperty) == LogisticsBlockGenericPipe.PipeRenderModel.REQUEST_TABLE) {
            TextureTransformation icon = SimpleServiceLocator.cclProxy.createIconTransformer((TextureAtlasSprite)Textures.LOGISTICS_REQUEST_TABLE_NEW);
            LogisticsNewSolidBlockWorldRenderer.BlockRotation rotation = LogisticsNewSolidBlockWorldRenderer.BlockRotation.getRotation((Integer)blockstate.func_177229_b((IProperty)LogisticsBlockGenericPipe.rotationProperty));
            objectsToRender.add(new RenderEntry(LogisticsNewSolidBlockWorldRenderer.block.get((Object)rotation), icon));
            for (LogisticsNewSolidBlockWorldRenderer.CoverSides side : LogisticsNewSolidBlockWorldRenderer.CoverSides.values()) {
                if (((Boolean)blockstate.func_177229_b((IProperty)LogisticsBlockGenericPipe.connectionPropertys.get(side.getDir(rotation)))).booleanValue()) continue;
                objectsToRender.add(new RenderEntry(LogisticsNewSolidBlockWorldRenderer.texturePlate_Outer.get((Object)side).get((Object)rotation), icon));
            }
        } else if (blockstate instanceof IExtendedBlockState) {
            IExtendedBlockState lpState = (IExtendedBlockState)blockstate;
            objectsToRender = (List)lpState.getValue((IUnlistedProperty)LogisticsBlockGenericPipe.propertyRenderList);
        }
        if (objectsToRender != null) {
            return objectsToRender;
        }
        return Collections.emptyList();
    }

    private CoreUnroutedPipe getPipe() {
        return nameTextureIdMap.get(this.key);
    }

    private List<RenderEntry> generatePipeRenderList() {
        ArrayList<RenderEntry> objectsToRender = new ArrayList<RenderEntry>();
        if (this.getPipe() == null) {
            System.out.println("'" + this.key + "' does not result in pipe");
        } else if (this.getPipe() instanceof PipeBlockRequestTable) {
            TextureTransformation icon = SimpleServiceLocator.cclProxy.createIconTransformer((TextureAtlasSprite)Textures.LOGISTICS_REQUEST_TABLE_NEW);
            LogisticsNewSolidBlockWorldRenderer.BlockRotation rotation = LogisticsNewSolidBlockWorldRenderer.BlockRotation.ZERO;
            objectsToRender.add(new RenderEntry(LogisticsNewSolidBlockWorldRenderer.block.get((Object)rotation), icon));
            for (LogisticsNewSolidBlockWorldRenderer.CoverSides side : LogisticsNewSolidBlockWorldRenderer.CoverSides.values()) {
                objectsToRender.add(new RenderEntry(LogisticsNewSolidBlockWorldRenderer.texturePlate_Outer.get((Object)side).get((Object)rotation), icon));
            }
        } else if (this.getPipe().getSpecialRenderer() != null) {
            this.getPipe().getSpecialRenderer().renderToList(null, objectsToRender);
            AxisAlignedBB[] bb = new AxisAlignedBB[]{new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5)};
            objectsToRender.forEach(it -> {
                bb[0] = bb[0].func_111270_a(it.getModel().bounds().toAABB());
            });
            double size = Math.max(Math.max(bb[0].field_72336_d - bb[0].field_72340_a, bb[0].field_72337_e - bb[0].field_72338_b), bb[0].field_72334_f - bb[0].field_72339_c);
            objectsToRender.replaceAll(it -> {
                RenderEntry content = it.clone(new I3DOperation[]{new LPUVTransformationList(BASE_TEXTURE_TRANSFORM)});
                content.getModel().apply(new LPScale(0.95 / size));
                return content;
            });
            bb[0] = new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5);
            objectsToRender.forEach(it -> {
                bb[0] = bb[0].func_111270_a(it.getModel().bounds().toAABB());
            });
            objectsToRender.forEach(it -> it.getModel().apply(new LPTranslation(0.5 - (bb[0].field_72336_d + bb[0].field_72340_a) / 2.0, 0.5 - (bb[0].field_72337_e + bb[0].field_72338_b) / 2.0, 0.5 - (bb[0].field_72334_f + bb[0].field_72339_c) / 2.0)));
        } else {
            if (this.getPipe() instanceof CoreRoutedPipe) {
                int red = 0;
                boolean toggle = Math.random() < 0.5;
                for (LogisticsNewRenderPipe.Corner corner : LogisticsNewRenderPipe.Corner.values()) {
                    int fred = red++;
                    boolean ftoggle = toggle;
                    objectsToRender.addAll(LogisticsNewRenderPipe.corners_M.get((Object)corner).stream().map(model -> new RenderEntry((IModel3D)model, ftoggle && (fred % 4 == 0 || fred % 4 == 3) || !ftoggle && (fred % 4 == 1 || fred % 4 == 2) ? LogisticsNewRenderPipe.inactiveTexture : LogisticsNewRenderPipe.basicPipeTexture)).collect(Collectors.toList()));
                    if (red <= 3) continue;
                    red -= 4;
                    toggle = !toggle;
                }
            } else {
                objectsToRender.addAll(Arrays.stream(LogisticsNewRenderPipe.Corner.values()).map(it -> LogisticsNewRenderPipe.corners_M.get(it).stream().map(model -> new RenderEntry((IModel3D)model, LogisticsNewRenderPipe.basicPipeTexture)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList()));
            }
            for (LogisticsNewRenderPipe.Edge edge : LogisticsNewRenderPipe.Edge.values()) {
                objectsToRender.add(new RenderEntry(LogisticsNewRenderPipe.edges.get((Object)edge), LogisticsNewRenderPipe.basicPipeTexture));
            }
            for (LogisticsNewRenderPipe.Edge edge : EnumFacing.field_82609_l) {
                for (IModel3D model2 : LogisticsNewRenderPipe.texturePlate_Outer.get((Object)edge)) {
                    TextureTransformation icon = Textures.LPnewPipeIconProvider.getIcon(this.getPipe().getTextureIndex());
                    if (icon == null) continue;
                    objectsToRender.add(new RenderEntry(model2, new LPUVTransformationList(new LPUVScale(0.75, 0.75), icon)));
                }
            }
        }
        return objectsToRender;
    }

    static {
        nameTextureIdMap = Maps.newLinkedHashMap();
    }

    public static class LogisticsNewPipeModelLoader
    implements ICustomModelLoader {
        public boolean accepts(ResourceLocation modelLocation) {
            if (modelLocation.func_110624_b().equals("logisticspipes") && modelLocation instanceof ModelResourceLocation) {
                Item item;
                ResourceLocation rl = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
                if (((ModelResourceLocation)modelLocation).func_177518_c().equals("inventory") && (item = (Item)ForgeRegistries.ITEMS.getValue(rl)) instanceof ItemLogisticsPipe) {
                    CoreUnroutedPipe pipe = ((ItemLogisticsPipe)item).getDummyPipe();
                    nameTextureIdMap.put((ModelResourceLocation)modelLocation, pipe);
                    return true;
                }
                if (rl.equals((Object)LPBlocks.pipe.getRegistryName())) {
                    return true;
                }
            }
            return false;
        }

        @Nonnull
        public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
            return new LogisticsNewPipeModel((ModelResourceLocation)modelLocation);
        }

        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        }
    }
}

