/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe.tube;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.tubes.HSTubeSCurve;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.I3DOperation;
import logisticspipes.proxy.object3d.interfaces.IBounds;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.operation.LPColourMultiplier;
import logisticspipes.proxy.object3d.operation.LPRotation;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.proxy.object3d.operation.LPUVTransformationList;
import logisticspipes.proxy.object3d.operation.LPUVTranslation;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.renderer.newpipe.RenderEntry;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class SCurveTubeRenderer
implements ISpecialPipeRenderer,
IHighlightPlacementRenderer {
    public static final SCurveTubeRenderer instance = new SCurveTubeRenderer();
    static Map<HSTubeSCurve.TurnSDirection, List<IModel3D>> tubeSCurveBase = new HashMap<HSTubeSCurve.TurnSDirection, List<IModel3D>>();
    static Map<HSTubeSCurve.TurnSDirection, Map<Pair<TubeMount, Integer>, IModel3D>> tubeSCurveMounts = new HashMap<HSTubeSCurve.TurnSDirection, Map<Pair<TubeMount, Integer>, IModel3D>>();
    public static Map<HSTubeSCurve.TurnSDirection, IModel3D> tubeSCurve = new HashMap<HSTubeSCurve.TurnSDirection, IModel3D>();
    private static final ResourceLocation TEXTURE = new ResourceLocation("logisticspipes", "textures/blocks/pipes/HS-Tube.png");

    private SCurveTubeRenderer() {
    }

    public static void loadModels() {
        try {
            Map<String, IModel3D> pipePartModels = SimpleServiceLocator.cclProxy.parseObjModels(LogisticsPipes.class.getResourceAsStream("/logisticspipes/models/HSTube-Gain_result.obj"), 7, new LPScale(0.01f));
            for (HSTubeSCurve.TurnSDirection turn : HSTubeSCurve.TurnSDirection.values()) {
                tubeSCurveBase.put(turn, new ArrayList());
            }
            pipePartModels.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("Lane ") || ((String)entry.getKey()).contains(" Lane ") || ((String)entry.getKey()).endsWith(" Lane")).forEach(entry -> {
                tubeSCurveBase.get(HSTubeSCurve.TurnSDirection.EAST).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPRotation(1.5707963267948966, 0, 0, 1)).apply(new LPTranslation(1.0, 0.0, 0.0)).apply(new LPRotation(-1.5707963267948966, 0, 1, 0))));
                tubeSCurveBase.get(HSTubeSCurve.TurnSDirection.NORTH).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPRotation(1.5707963267948966, 0, 0, 1)).apply(new LPTranslation(1.0, 0.0, 1.0))));
                tubeSCurveBase.get(HSTubeSCurve.TurnSDirection.EAST_INV).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPRotation(-1.5707963267948966, 0, 0, 1)).apply(new LPTranslation(-2.0, 1.0, 4.0)).apply(new LPRotation(1.5707963267948966, 0, 1, 0))));
                tubeSCurveBase.get(HSTubeSCurve.TurnSDirection.NORTH_INV).add(LogisticsNewRenderPipe.compute(((IModel3D)entry.getValue()).twoFacedCopy().apply(new LPRotation(-1.5707963267948966, 0, 0, 1)).apply(new LPTranslation(-2.0, 1.0, 3.0)).apply(new LPRotation(Math.PI, 0, 1, 0))));
            });
            if (tubeSCurveBase.get(HSTubeSCurve.TurnSDirection.NORTH).size() != 4) {
                throw new RuntimeException("Couldn't load Tube Lanes. Only loaded " + tubeSCurveBase.get(HSTubeSCurve.TurnSDirection.NORTH).size());
            }
            for (HSTubeSCurve.TurnSDirection turn : HSTubeSCurve.TurnSDirection.values()) {
                tubeSCurve.put(turn, SimpleServiceLocator.cclProxy.combine((Collection<IModel3D>)tubeSCurveBase.get(turn)));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void renderToList(CoreUnroutedPipe pipe, List<RenderEntry> objectsToRender) {
        HSTubeSCurve tube;
        if (pipe instanceof HSTubeSCurve && (tube = (HSTubeSCurve)pipe).getOrientation() != null) {
            objectsToRender.addAll(tubeSCurveBase.get(tube.getOrientation().getRenderOrientation()).stream().map(model -> new RenderEntry((IModel3D)model, new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.0f))}, TEXTURE)).collect(Collectors.toList()));
        }
        if (pipe == null) {
            objectsToRender.addAll(tubeSCurveBase.get(HSTubeSCurve.TurnSDirection.NORTH).stream().map(model -> new RenderEntry((IModel3D)model, new I3DOperation[]{new LPUVTransformationList(new LPUVTranslation(0.0f, 0.0f))}, TEXTURE)).collect(Collectors.toList()));
        }
    }

    @Override
    public void renderHighlight(ITubeOrientation orientation) {
        tubeSCurve.get(orientation.getRenderOrientation()).render(LPColourMultiplier.instance(-1));
    }

    public static AxisAlignedBB getObjectBoundsAt(AxisAlignedBB boundingBox, ITubeOrientation orientation) {
        IModel3D model = tubeSCurve.get(orientation.getRenderOrientation());
        IBounds c = model.getBoundsInside(boundingBox);
        if (c != null) {
            return c.toAABB();
        }
        return null;
    }

    static {
        SCurveTubeRenderer.loadModels();
    }

    static enum TubeMount {
        UP_LEFT,
        UP_RIGHT,
        DOWN_LEFT,
        DOWN_RIGHT;

    }
}

