/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.LinkedList;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.InventoryUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import network.rs485.logisticspipes.connection.NeighborTileEntity;

public class InventoryUtilFactory {
    private final LinkedList<SpecialInventoryHandler> handler = new LinkedList();

    public void registerHandler(SpecialInventoryHandler invHandler) {
        if (invHandler.init()) {
            this.handler.addLast(invHandler);
            LogisticsPipes.log.info("Loaded SpecialInventoryHandler: " + invHandler.getClass().getCanonicalName());
        } else {
            LogisticsPipes.log.warn("Could not load SpecialInventoryHandler: " + invHandler.getClass().getCanonicalName());
        }
    }

    public SpecialInventoryHandler getUtilForInv(ICapabilityProvider inv, EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        if (!(inv instanceof TileEntity)) {
            return null;
        }
        for (SpecialInventoryHandler invHandler : this.handler) {
            if (!invHandler.isType((TileEntity)inv, dir)) continue;
            return invHandler.getUtilForTile((TileEntity)inv, dir, hideOnePerStack, hideOne, cropStart, cropEnd);
        }
        return null;
    }

    @Nullable
    public IInventoryUtil getInventoryUtil(NeighborTileEntity<TileEntity> adj) {
        return this.getHidingInventoryUtil(adj.getTileEntity(), adj.getOurDirection(), false, false, 0, 0);
    }

    @Nullable
    public IInventoryUtil getInventoryUtil(TileEntity inv, EnumFacing dir) {
        return this.getHidingInventoryUtil(inv, dir, false, false, 0, 0);
    }

    @Nullable
    public IInventoryUtil getHidingInventoryUtil(TileEntity tile, EnumFacing dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        IInventoryUtil util = this.getUtilForInv((ICapabilityProvider)tile, dir, hideOnePerStack, hideOne, cropStart, cropEnd);
        if (util == null && tile != null && tile.hasCapability(LogisticsPipes.ITEM_HANDLER_CAPABILITY, dir)) {
            util = new InventoryUtil((IItemHandler)tile.getCapability(LogisticsPipes.ITEM_HANDLER_CAPABILITY, dir), hideOnePerStack, hideOne, cropStart, cropEnd);
        }
        return util;
    }
}

