/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import com.google.common.reflect.Reflection;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.lwjgl.opengl.GL11;

public class OpenGLDebugger {
    private static HashMap<Integer, String> niceToHave = null;
    private static int probeID = 0;
    private Thread probeGUIThread;
    private int cycleCount;
    private boolean started;
    private ExtendedHashMap glStuff;
    private ConcurrentHashMap<Integer, GLTypes> glVariablesToCheck;
    private final Lock debuggerLock;
    private final Condition glVariablesCondition;
    private boolean glVariablesUpdated;
    private int printOnCycle;

    public OpenGLDebugger(int printOnCycle) {
        if (printOnCycle < 1) {
            throw new IllegalArgumentException("Print per cycle must be at least 1");
        }
        if (niceToHave == null) {
            OpenGLDebugger.updateNiceToHave();
        }
        this.debuggerLock = new ReentrantLock();
        this.glVariablesCondition = this.debuggerLock.newCondition();
        this.printOnCycle = printOnCycle;
        this.glStuff = new ExtendedHashMap();
        this.glVariablesToCheck = new ConcurrentHashMap();
        this.probeGUIThread = new Thread((Runnable)new ProbeGUI(), "LogisticsPipes GLDebug Probe #" + probeID);
        ++probeID;
    }

    public void start() {
        if (!this.started) {
            this.started = true;
            this.cycleCount = 0;
            this.probeGUIThread.start();
        }
    }

    public void stop() {
        if (this.started) {
            this.debuggerLock.lock();
            try {
                this.started = false;
                this.glVariablesUpdated = true;
                this.glVariablesCondition.signal();
            }
            finally {
                this.debuggerLock.unlock();
            }
        }
    }

    public void cycle() {
        if (this.started) {
            ++this.cycleCount;
            if (this.cycleCount % this.printOnCycle == 0) {
                this.saveOpenGLStuff();
                this.cycleCount = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOpenGLStuff() {
        this.debuggerLock.lock();
        try {
            Iterator i = ((ConcurrentHashMap.KeySetView)this.glVariablesToCheck.keySet()).iterator();
            this.glStuff.startSession();
            while (i.hasNext()) {
                Integer key = (Integer)i.next();
                Boolean value = GL11.glGetBoolean((int)key);
                if (GL11.glGetError() == 1280) {
                    i.remove();
                    continue;
                }
                this.glStuff.put(key, (Object)value);
            }
            this.glStuff.stopSession();
            this.glVariablesUpdated = true;
            this.glVariablesCondition.signal();
        }
        finally {
            this.debuggerLock.unlock();
        }
    }

    private static void updateNiceToHave() {
        niceToHave = new HashMap();
        int crawlerVersion = 11;
        boolean almostEnd = false;
        boolean end = false;
        while (!end) {
            String packageGL = String.format("%s%d", "GL", crawlerVersion);
            String nextGL = String.format("%s.%s", "org.lwjgl.opengl", packageGL);
            try {
                ++crawlerVersion;
                Class<?> glClass = GL11.class.getClassLoader().loadClass(nextGL);
                Reflection.initialize((Class[])new Class[]{glClass});
                almostEnd = false;
                for (Field f : glClass.getDeclaredFields()) {
                    try {
                        if (!f.getType().equals(Integer.TYPE)) continue;
                        int id = f.getInt(null);
                        String nice = f.getName();
                        if (nice.endsWith("BIT")) continue;
                        if (niceToHave.containsKey(id) && !niceToHave.get(id).equals(nice)) {
                            System.out.printf("NiceToHave: ID %d exists. Replacing %s with %s!!%n", id, niceToHave.remove(id), nice);
                        }
                        niceToHave.put(id, String.format("%s.%s", packageGL, nice));
                    }
                    catch (IllegalArgumentException e) {
                        System.out.printf("NiceToHave: Illegal Argument!%nNiceToHave: %s%n", e);
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        System.out.printf("NiceToHave: Illegal Access!%nNiceToHave: %s%n", e);
                        e.printStackTrace();
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (almostEnd) {
                    end = true;
                    continue;
                }
                almostEnd = true;
                crawlerVersion = (crawlerVersion / 10 + 1) * 10;
            }
        }
    }

    public int getPrintOnCycle() {
        return this.printOnCycle;
    }

    public OpenGLDebugger setPrintOnCycle(int printOnCycle) {
        this.printOnCycle = printOnCycle;
        return this;
    }

    public class ProbeGUI
    extends JDialog
    implements Runnable {
        private JPanel mainPanel;
        private JTable variableMonitorTable;
        private JButton closeButton;

        public ProbeGUI() {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                try {
                    UIManager.setLookAndFeel(info.getClassName());
                }
                catch (ReflectiveOperationException | UnsupportedLookAndFeelException e2) {
                    e2.printStackTrace();
                }
                break;
            }
            this.setupUI();
            this.setType(Window.Type.UTILITY);
            this.setContentPane(this.mainPanel);
            this.getRootPane().setDefaultButton(this.closeButton);
            this.variableMonitorTable.setModel(new SpecialTableModel());
            SpecialTableCellRenderer cellRenderer = new SpecialTableCellRenderer();
            this.variableMonitorTable.getColumnModel().getColumn(0).setCellRenderer(cellRenderer);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    OpenGLDebugger.this.stop();
                }
            });
            this.mainPanel.registerKeyboardAction(e -> OpenGLDebugger.this.stop(), KeyStroke.getKeyStroke(27, 0), 1);
        }

        @Override
        public void run() {
            for (Integer key : niceToHave.keySet()) {
                OpenGLDebugger.this.glVariablesToCheck.put(key, GLTypes.BOOLEAN);
            }
            this.pack();
            this.setVisible(true);
            while (OpenGLDebugger.this.started) {
                OpenGLDebugger.this.debuggerLock.lock();
                try {
                    while (!OpenGLDebugger.this.glVariablesUpdated) {
                        OpenGLDebugger.this.glVariablesCondition.await();
                    }
                    OpenGLDebugger.this.glVariablesUpdated = false;
                    this.updateVariables();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    OpenGLDebugger.this.debuggerLock.unlock();
                }
            }
        }

        private void updateVariables() {
            DefaultTableModel dtm = (DefaultTableModel)this.variableMonitorTable.getModel();
            dtm.fireTableDataChanged();
        }

        private void setupUI() {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null));
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 5, 0, 0);
            this.mainPanel.add((Component)this.closeButton, gbc);
            JButton addButton = new JButton();
            addButton.setText("Add");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 5, 0, 0);
            this.mainPanel.add((Component)addButton, gbc);
            JTextField addTextField = new JTextField();
            addTextField.setText("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            this.mainPanel.add((Component)addTextField, gbc);
            JScrollPane monitorTableScrollPane = new JScrollPane();
            monitorTableScrollPane.setHorizontalScrollBarPolicy(31);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 3;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 0, 5, 0);
            this.mainPanel.add((Component)monitorTableScrollPane, gbc);
            this.variableMonitorTable = new JTable();
            this.variableMonitorTable.setEnabled(false);
            monitorTableScrollPane.setViewportView(this.variableMonitorTable);
        }
    }

    public class SpecialTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table == null) {
                return this;
            }
            this.setBackground(null);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (row < OpenGLDebugger.this.glStuff.getStopUpdatedIndex()) {
                this.setBackground(Color.YELLOW);
            } else if (row < OpenGLDebugger.this.glStuff.getStopNewIndex()) {
                this.setBackground(Color.GREEN);
            }
            return this;
        }
    }

    public class SpecialTableModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Key";
                }
                case 1: {
                    return "Value";
                }
            }
            return "<NOVALUE>";
        }

        @Override
        public int getRowCount() {
            return OpenGLDebugger.this.glStuff.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                int index = OpenGLDebugger.this.glStuff.getKey(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return OpenGLDebugger.this.glStuff.getName(index);
                    }
                    case 1: {
                        return OpenGLDebugger.this.glStuff.get(index);
                    }
                }
                return "<NOVALUE>";
            }
            catch (IndexOutOfBoundsException e) {
                return "<EXCEPTION>";
            }
        }
    }

    public static class ExtendedHashMap
    extends HashMap<Integer, Object> {
        private ArrayList<Integer> orderedKeys = new ArrayList();
        private ArrayList<Integer> newKeys;
        private ArrayList<Integer> updatedKeys;
        private boolean sessionStarted = false;
        private int stopUpdatedIndex;
        private int stopNewIndex;

        public int getStopUpdatedIndex() {
            return this.stopUpdatedIndex;
        }

        public int getStopNewIndex() {
            return this.stopNewIndex;
        }

        @Override
        public void putAll(Map<? extends Integer, ?> m) {
            throw new UnsupportedOperationException();
        }

        public void startSession() {
            this.newKeys = new ArrayList();
            this.updatedKeys = new ArrayList();
            this.sessionStarted = true;
        }

        @Override
        public Object put(Integer key, Object value) {
            if (!this.sessionStarted) {
                throw new UnsupportedOperationException("Session not started");
            }
            if (this.containsKey(key)) {
                if (this.get(key).equals(value)) {
                    return value;
                }
                this.orderedKeys.remove(key);
                this.updatedKeys.add(key);
            } else {
                this.newKeys.add(key);
            }
            return super.put(key, value);
        }

        public void stopSession() {
            this.stopNewIndex = this.newKeys.size();
            this.orderedKeys.addAll(0, this.newKeys);
            this.newKeys = null;
            this.stopUpdatedIndex = this.updatedKeys.size();
            this.stopNewIndex += this.stopUpdatedIndex;
            this.orderedKeys.addAll(0, this.updatedKeys);
            this.updatedKeys = null;
            this.sessionStarted = false;
        }

        public String getName(Integer key) {
            return (String)niceToHave.get(key);
        }

        public int getKey(int index) {
            return this.orderedKeys.get(index);
        }
    }

    private static enum GLTypes {
        BOOLEAN(Boolean.class, "boolean", "GL11.glGetBoolean"),
        DOUBLE(Double.class, "double", "GL11.glGetDouble"),
        FLOAT(Float.class, "float", "GL11.glGetFloat"),
        INTEGER(Integer.class, "int", "GL11.glGetInteger"),
        INTEGER64(Long.class, "long", "GL32.glGetInteger64");

        private Class javaClass;
        private String getterFunction;
        private String niceName;

        private GLTypes(Class javaClass, String niceName, String getterFunction) {
            this.javaClass = javaClass;
            this.niceName = niceName;
            this.getterFunction = getterFunction;
        }

        public Class getJavaClass() {
            return this.javaClass;
        }

        public String getGetterFunction() {
            return this.getterFunction;
        }

        public String getNiceName() {
            return this.niceName;
        }
    }
}

