/*
 * Decompiled with CFR 0.152.
 */
package nc.network.config;

import io.netty.buffer.ByteBuf;
import nc.config.NCConfig;
import nc.util.NCUtil;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ConfigUpdatePacket
implements IMessage {
    protected boolean messageValid;
    public boolean radiation_enabled;
    public boolean radiation_horse_armor;

    public ConfigUpdatePacket() {
        this.messageValid = false;
    }

    public ConfigUpdatePacket(boolean radiation_enabled, boolean radiation_horse_armor) {
        this.radiation_enabled = radiation_enabled;
        this.radiation_horse_armor = radiation_horse_armor;
        this.messageValid = true;
    }

    public void readMessage(ByteBuf buf) {
        this.radiation_enabled = buf.readBoolean();
        this.radiation_horse_armor = buf.readBoolean();
    }

    public void writeMessage(ByteBuf buf) {
        buf.writeBoolean(this.radiation_enabled);
        buf.writeBoolean(this.radiation_horse_armor);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.readMessage(buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            NCUtil.getLogger().catching((Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        this.writeMessage(buf);
    }

    public static class Handler
    implements IMessageHandler<ConfigUpdatePacket, IMessage> {
        public IMessage onMessage(ConfigUpdatePacket message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.processMessage(message));
            return null;
        }

        protected void processMessage(ConfigUpdatePacket message) {
            NCConfig.onConfigPacket(message);
        }
    }
}

