/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.config;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.config.ConcreteConfig;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ConcreteGuiFactory
implements IModGuiFactory {
    private final Configuration config;
    private final String modID;
    private final String title;

    protected ConcreteGuiFactory(ConcreteConfig concreteConfig) {
        this(concreteConfig.getConfiguration(), concreteConfig.getModID(), I18n.func_135052_a((String)(concreteConfig.getModID() + ".configgui.title"), (Object[])new Object[0]));
    }

    protected ConcreteGuiFactory(Configuration config, String modID, String title) {
        this.config = config;
        this.modID = modID;
        this.title = title;
    }

    public boolean hasConfigGui() {
        return true;
    }

    public void initialize(Minecraft minecraftInstance) {
    }

    public GuiScreen createConfigGui(GuiScreen parentScreen) {
        return new GuiConfig(parentScreen, this.collectConfigElements(), this.modID, false, false, this.title);
    }

    private List<IConfigElement> collectConfigElements() {
        List<ConfigElement> configElements;
        Set categoryNames = this.config.getCategoryNames();
        if (categoryNames.size() == 1) {
            configElements = new ConfigElement(this.config.getCategory((String)categoryNames.iterator().next())).getChildElements();
        } else {
            configElements = Lists.newArrayListWithCapacity((int)categoryNames.size());
            for (String categoryName : categoryNames) {
                configElements.add(new ConfigElement(this.config.getCategory(categoryName)));
            }
        }
        configElements.sort(Comparator.comparing(e -> I18n.func_135052_a((String)e.getLanguageKey(), (Object[])new Object[0])));
        return configElements;
    }

    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return null;
    }
}

