/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.util;

import xt9.deepmoblearning.common.config.Config;
import xt9.deepmoblearning.common.util.MathHelper;

public class DataModelExperience {
    private static final int[] killMultiplier = new int[]{MathHelper.ensureRange(Config.modelExperience.get("killMultiplierTier0").getInt(), 1, 100), MathHelper.ensureRange(Config.modelExperience.get("killMultiplierTier1").getInt(), 1, 100), MathHelper.ensureRange(Config.modelExperience.get("killMultiplierTier2").getInt(), 1, 100), MathHelper.ensureRange(Config.modelExperience.get("killMultiplierTier3").getInt(), 1, 100), 0};
    private static final int[] maxExperience = new int[]{MathHelper.ensureRange(Config.modelExperience.get("killsToTier1").getInt(), 1, 500) * killMultiplier[0], MathHelper.ensureRange(Config.modelExperience.get("killsToTier2").getInt(), 1, 500) * killMultiplier[1], MathHelper.ensureRange(Config.modelExperience.get("killsToTier3").getInt(), 1, 500) * killMultiplier[2], MathHelper.ensureRange(Config.modelExperience.get("killsToTier4").getInt(), 1, 500) * killMultiplier[3]};

    public static boolean shouldIncreaseTier(int tier, int kc, int sc) {
        if (tier == 4) {
            return false;
        }
        int killExperience = kc * killMultiplier[tier];
        int roof = maxExperience[tier];
        return killExperience + sc >= roof;
    }

    public static double getCurrentTierKillCountWithSims(int tier, int kc, int sc) {
        if (tier == 4) {
            return 0.0;
        }
        return (double)kc + (double)sc / (double)killMultiplier[tier];
    }

    public static int getCurrentTierSimulationCountWithKills(int tier, int kc, int sc) {
        if (tier == 4) {
            return 0;
        }
        return sc + kc * killMultiplier[tier];
    }

    public static double getKillsToNextTier(int tier, int kc, int sc) {
        if (tier == 4) {
            return 0.0;
        }
        int killRoof = DataModelExperience.getTierRoof(tier, true);
        return (double)killRoof - DataModelExperience.getCurrentTierKillCountWithSims(tier, kc, sc);
    }

    public static int getSimulationsToNextTier(int tier, int kc, int sc) {
        if (tier == 4) {
            return 0;
        }
        int roof = DataModelExperience.getTierRoof(tier, false);
        return roof - DataModelExperience.getCurrentTierSimulationCountWithKills(tier, kc, sc);
    }

    public static int getTierRoof(int tier, boolean asKills) {
        if (tier == 4) {
            return 0;
        }
        if (!asKills) {
            return maxExperience[tier];
        }
        return maxExperience[tier] / killMultiplier[tier];
    }

    public static int getKillMultiplier(int tier) {
        return killMultiplier[tier];
    }
}

