/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.model;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.CachedBuilderModel;
import com.jaquadro.minecraft.chameleon.model.ChamModel;
import com.jaquadro.minecraft.chameleon.model.ProxyBuilderModel;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.resources.IconUtil;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGeometry;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.modeldata.DrawerStateModelData;
import com.jaquadro.minecraft.storagedrawers.block.modeldata.MaterialModelData;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerDecoratorModel;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerSealedModel;
import eutros.framedcompactdrawers.block.BlockDrawersCustomComp;
import eutros.framedcompactdrawers.model.ForkedDrawerRenderer;
import eutros.framedcompactdrawers.registry.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public class CustomDrawersCompModel
extends ChamModel {
    private static final ItemHandler itemHandler = new ItemHandler();
    private TextureAtlasSprite iconParticle;

    private CustomDrawersCompModel(IBlockState state, boolean mergeLayers) {
        this(state, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, mergeLayers);
    }

    private CustomDrawersCompModel(IBlockState state, @Nonnull ItemStack effMatFront, @Nonnull ItemStack effMatSide, @Nonnull ItemStack effMatTrim, @Nonnull ItemStack matFront, @Nonnull ItemStack matSide, @Nonnull ItemStack matTrim, boolean mergeLayers) {
        super(state, mergeLayers, new Object[]{effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim});
    }

    public static IBakedModel fromBlock(IBlockState state) {
        if (!(state instanceof IExtendedBlockState)) {
            return new CustomDrawersCompModel(state, false);
        }
        IExtendedBlockState xState = (IExtendedBlockState)state;
        DrawerStateModelData stateModel = (DrawerStateModelData)xState.getValue(BlockDrawers.STATE_MODEL);
        MaterialModelData matModel = (MaterialModelData)xState.getValue(BlockDrawersCustom.MAT_MODEL);
        if (stateModel == null || matModel == null) {
            return new CustomDrawersCompModel(state, false);
        }
        ItemStack effMatFront = matModel.getEffectiveMaterialFront();
        ItemStack effMatSide = matModel.getEffectiveMaterialSide();
        ItemStack effMatTrim = matModel.getEffectiveMaterialTrim();
        ItemStack matFront = matModel.getMaterialFront();
        ItemStack matSide = matModel.getMaterialSide();
        ItemStack matTrim = matModel.getMaterialTrim();
        return new CustomDrawersCompModel(state, effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim, false);
    }

    public static IBakedModel fromItem(@Nonnull ItemStack stack) {
        IBlockState state = ModBlocks.framedCompactDrawer.func_176203_a(stack.func_77960_j());
        if (!stack.func_77942_o()) {
            return new CustomDrawersCompModel(state, true);
        }
        NBTTagCompound tag = stack.func_77978_p();
        ItemStack matFront = ItemStack.field_190927_a;
        ItemStack matSide = ItemStack.field_190927_a;
        ItemStack matTrim = ItemStack.field_190927_a;
        assert (tag != null);
        if (tag.func_150297_b("MatF", 10)) {
            matFront = new ItemStack(tag.func_74775_l("MatF"));
        }
        if (tag.func_150297_b("MatS", 10)) {
            matSide = new ItemStack(tag.func_74775_l("MatS"));
        }
        if (tag.func_150297_b("MatT", 10)) {
            matTrim = new ItemStack(tag.func_74775_l("MatT"));
        }
        ItemStack effMatFront = !matFront.func_190926_b() ? matFront : matSide;
        ItemStack effMatTrim = !matTrim.func_190926_b() ? matTrim : matSide;
        ItemStack effMatSide = matSide;
        CustomDrawersCompModel model = new CustomDrawersCompModel(state, effMatFront, effMatSide, effMatTrim, matFront, matSide, matTrim, true);
        if (!stack.func_77978_p().func_150297_b("tile", 10)) {
            return model;
        }
        return new DrawerSealedModel((IBakedModel)model, state, true);
    }

    protected void renderMippedLayer(ChamRender renderer, IBlockState state, Object ... args) {
        TextureAtlasSprite iconTrim;
        EnumCompDrawer slots = (EnumCompDrawer)state.func_177229_b(BlockDrawersCustomComp.SLOTS);
        int index = 3 - slots.getOpenSlots();
        ItemStack itemFront = (ItemStack)args[0];
        ItemStack itemSide = (ItemStack)args[1];
        ItemStack itemTrim = (ItemStack)args[2];
        TextureAtlasSprite iconFront = !itemFront.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemFront) : null;
        TextureAtlasSprite iconSide = !itemSide.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemSide) : null;
        TextureAtlasSprite textureAtlasSprite = iconTrim = !itemTrim.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemTrim) : null;
        if (iconFront == null) {
            iconFront = iconSide;
        }
        if (iconTrim == null) {
            iconTrim = iconSide;
        }
        if (iconFront == null) {
            iconFront = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultFront[index]);
        }
        if (iconSide == null) {
            iconSide = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        if (iconTrim == null) {
            iconTrim = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        this.iconParticle = iconSide;
        ForkedDrawerRenderer drawerRenderer = new ForkedDrawerRenderer(renderer);
        drawerRenderer.renderBasePass(null, state, BlockPos.field_177992_a, (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING), iconSide, iconTrim, iconFront);
    }

    protected void renderTransLayer(ChamRender renderer, IBlockState state, Object ... args) {
        EnumCompDrawer slots = (EnumCompDrawer)state.func_177229_b(BlockDrawersCustomComp.SLOTS);
        int index = 3 - slots.getOpenSlots();
        TextureAtlasSprite iconOverlayFace = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayFace);
        TextureAtlasSprite iconOverlayHandle = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayHandle);
        TextureAtlasSprite iconOverlayDisabled = Chameleon.instance.iconRegistry.getIcon(Register.iconDisabledOverlay[index]);
        ItemStack itemTrim = (ItemStack)args[5];
        TextureAtlasSprite iconTrim = !itemTrim.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemTrim) : null;
        TextureAtlasSprite iconOverlayTrim = iconTrim == null ? Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayBoldTrim) : Chameleon.instance.iconRegistry.getIcon(Register.iconOverlayTrim);
        ForkedDrawerRenderer drawerRenderer = new ForkedDrawerRenderer(renderer);
        drawerRenderer.renderOverlayPass(null, state, BlockPos.field_177992_a, (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING), iconOverlayTrim, iconOverlayHandle, iconOverlayFace, iconOverlayDisabled);
    }

    public TextureAtlasSprite func_177554_e() {
        return this.iconParticle;
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    private static class ItemHandler
    extends ItemOverrideList {
        public ItemHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
            return CustomDrawersCompModel.fromItem(stack);
        }
    }

    public static class Model
    extends ProxyBuilderModel {
        public Model() {
            super(Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide));
        }

        protected IBakedModel buildModel(IBlockState state, IBakedModel parent) {
            IBakedModel mainModel = CustomDrawersCompModel.fromBlock(state);
            if (!(state instanceof IExtendedBlockState)) {
                return mainModel;
            }
            IExtendedBlockState xState = (IExtendedBlockState)state;
            DrawerStateModelData stateModel = (DrawerStateModelData)xState.getValue(BlockDrawers.STATE_MODEL);
            try {
                if (!DrawerDecoratorModel.shouldHandleState((DrawerStateModelData)stateModel)) {
                    return mainModel;
                }
                EnumCompDrawer drawer = (EnumCompDrawer)state.func_177229_b(BlockDrawersCustomComp.SLOTS);
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockDrawers.FACING);
                DrawerDecoratorModel decModel = new DrawerDecoratorModel(mainModel, xState, (IDrawerGeometry)drawer, dir, stateModel);
                decModel.addBaseRenderLayer(BlockRenderLayer.TRANSLUCENT);
                return decModel;
            }
            catch (Throwable t) {
                try {
                    return mainModel;
                }
                catch (Throwable t2) {
                    return parent;
                }
            }
        }

        public ItemOverrideList func_188617_f() {
            return itemHandler;
        }

        public List<Object> getKey(IBlockState state) {
            try {
                ArrayList<Object> key = new ArrayList<Object>();
                IExtendedBlockState xState = (IExtendedBlockState)state;
                key.add(xState.getValue(BlockDrawers.STATE_MODEL));
                key.add(xState.getValue(BlockDrawersCustom.MAT_MODEL));
                return key;
            }
            catch (Throwable t) {
                return super.getKey(state);
            }
        }
    }

    public static class Register
    extends DefaultRegister<BlockDrawersCustomComp> {
        public static final ResourceLocation iconDefaultSide = new ResourceLocation("framedcompactdrawers:blocks/raw_side");
        public static final ResourceLocation[] iconDefaultFront = new ResourceLocation[]{new ResourceLocation("framedcompactdrawers:blocks/drawers_comp_raw_open_3"), new ResourceLocation("framedcompactdrawers:blocks/drawers_comp_raw_open_2"), new ResourceLocation("framedcompactdrawers:blocks/drawers_comp_raw_open_1")};
        public static final ResourceLocation[] iconDisabledOverlay = new ResourceLocation[]{new ResourceLocation("framedcompactdrawers:blocks/overlay/open_3"), new ResourceLocation("framedcompactdrawers:blocks/overlay/open_2"), new ResourceLocation("framedcompactdrawers:blocks/overlay/open_1")};
        public static final ResourceLocation iconOverlayTrim = new ResourceLocation("framedcompactdrawers:blocks/overlay/shading_trim");
        public static final ResourceLocation iconOverlayBoldTrim = new ResourceLocation("framedcompactdrawers:blocks/overlay/shading_bold_trim");
        public static final ResourceLocation iconOverlayFace = new ResourceLocation("framedcompactdrawers:blocks/overlay/shading_face");
        public static final ResourceLocation iconOverlayHandle = new ResourceLocation("framedcompactdrawers:blocks/overlay/handle");

        public Register() {
            super((Block)ModBlocks.framedCompactDrawer);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (EnumCompDrawer drawer : EnumCompDrawer.values()) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    states.add(ModBlocks.framedCompactDrawer.func_176223_P().func_177226_a(BlockDrawersCustomComp.SLOTS, (Comparable)drawer).func_177226_a((IProperty)BlockDrawers.FACING, (Comparable)dir));
                }
            }
            return states;
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model());
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model());
        }

        public List<ResourceLocation> getTextureResources() {
            ArrayList<ResourceLocation> resource = new ArrayList<ResourceLocation>();
            resource.addAll(Arrays.asList(iconDefaultFront));
            resource.addAll(Arrays.asList(iconDisabledOverlay));
            resource.add(iconDefaultSide);
            resource.add(iconOverlayTrim);
            resource.add(iconOverlayBoldTrim);
            resource.add(iconOverlayFace);
            resource.add(iconOverlayHandle);
            return resource;
        }
    }
}

