/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.lumberjack;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="lumberjack", category="All")
@Mod.EventBusSubscriber(modid="lumberjack")
@Config.LangKey(value="lumberjack.config.lumberjack")
public class ModConfig {
    @Config.Name(value="Total Limit")
    @Config.LangKey(value="lumberjack.config.totalLimit")
    @Config.Comment(value={"Hard limit of the amount that can be broken in one go."})
    @Config.RangeInt(min=1, max=10000)
    public static int totalLimit = 1024;
    @Config.Name(value="Tick Limit")
    @Config.LangKey(value="lumberjack.config.tickLimit")
    @Config.Comment(value={"Hard limit of the amount that can be broken in one go."})
    @Config.RangeInt(min=1, max=10000)
    public static int tickLimit = 32;
    @Config.Name(value="Axe Mode")
    @Config.LangKey(value="lumberjack.config.mode")
    @Config.Comment(value={"Valid modes:\n0: Only chop blocks with the same blockid\n1: Chop all wooden blocks"})
    @Config.RangeInt(min=0, max=1)
    public static int mode = 0;
    @Config.Name(value="Chop Leaves")
    @Config.LangKey(value="lumberjack.config.leaves")
    @Config.Comment(value={"Harvest leaves too."})
    public static boolean leaves = false;
    @Config.Name(value="Use all Materials")
    @Config.LangKey(value="lumberjack.config.useAllMaterials")
    @Config.Comment(value={"If you set this to false, we will only clone other axes, and not try to use all ToolMaterials."})
    public static boolean useAllMaterials = false;
    @Config.Name(value="Ban List")
    @Config.LangKey(value="lumberjack.config.banList")
    @Config.Comment(value={"A list of names you don't want to see as lumberaxes.\nNot case sensitive, but it uses the RAW ToolMaterial name. AKA it does not strip modid's or oter 'unique making techniques' mod authors may use to prevent conflicts with materials from other mods.\nUse * as a wildcard at the beginning or end to match with endsWith or startsWith respectively.\nExample: 'BASEMETALS_*' will prevent any material that starts with 'BASEMETALS_' from becoming a lumberaxe."})
    public static String[] banList = new String[0];

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("lumberjack")) {
            ConfigManager.sync((String)"lumberjack", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

