/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.biome.provider.layers;

public class BiomeEdgeData {
    private int[] biomes = null;
    private int[] whitelist = null;
    private int[] blacklist = null;
    private int edge = 0;

    public boolean useEdge(int biome) {
        if (!this.usedForBiome(biome)) {
            if (this.whitelist == null && this.blacklist == null) {
                return true;
            }
            if (this.whitelist == null ? !this.inBlacklist(biome) : this.blacklist == null && this.inWhitelist(biome)) {
                return true;
            }
        }
        return false;
    }

    private boolean inWhitelist(int biome) {
        if (this.whitelist != null) {
            for (int biomeID : this.whitelist) {
                if (biomeID != biome) continue;
                return true;
            }
        }
        return false;
    }

    private boolean inBlacklist(int biome) {
        if (this.blacklist != null) {
            for (int biomeID : this.blacklist) {
                if (biomeID != biome) continue;
                return true;
            }
        }
        return false;
    }

    public boolean usedForBiome(int biome) {
        if (this.biomes != null) {
            for (int biomeID : this.biomes) {
                if (biomeID != biome) continue;
                return true;
            }
        }
        return false;
    }

    public void setBlacklist(int[] list) {
        this.blacklist = list;
    }

    public void setWhitelist(int[] list) {
        this.whitelist = list;
    }

    public void setBiomes(int[] biomeIDs) {
        this.biomes = biomeIDs;
    }

    public void setEdge(int biomeID) {
        this.edge = biomeID;
    }

    public int getEdge() {
        return this.edge;
    }
}

