/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.biome.provider.layers;

import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation//biome_providers//genlayers/GenLayerBaseSingle", classExplaination="A layer to be used as a base to fill the world with a single biome. Good for when you want a single base biome.")
public class GenLayerBaseSingle
extends GenLayer {
    private int biome;

    @ScriptMethodDocumentation(args="long", usage="layer base seed", notes="Constructs the layer with the single biome set to 0/\"Ocean\".")
    public GenLayerBaseSingle(long seed) {
        super(seed);
    }

    @ScriptArgs(args={ArgType.LONG, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="layer base seed, biome ID", notes="Constructs the layer and sets the biome it will fill the world with.")
    public GenLayerBaseSingle(long seed, int biome) {
        this(seed);
        this.biome = biome;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome ID", notes="Sets the biome this layer will fill the world with.")
    public void setBiome(int biome) {
        this.biome = biome;
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int[] returnInts = IntCache.func_76445_a((int)(width * depth));
        for (int i = 0; i < returnInts.length; ++i) {
            returnInts[i] = this.biome;
        }
        return returnInts;
    }
}

