/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.Random;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.fluids.BlockFluidBase;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/BiomeBlockReplacementGenerator", classExplaination="This file is for the BiomeBlockReplacementGenerator. This generator handles top/filler block replacements for biomes. Not quite the same as the overworld, but similar.")
public class BiomeBlockReplacementGenerator
implements IGenerator {
    public Biome[] biomesForGeneration;
    public NoiseGeneratorPerlin surfaceNoise;
    public double[] depthBuffer = new double[256];
    private final int seaHeight;
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState RED_SANDSTONE = Blocks.field_180395_cM.func_176223_P();
    protected static final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();

    @ScriptMethodDocumentation(usage="", notes="This constructs a BiomeBlockReplacementGenerator with a sea height of 0.")
    public BiomeBlockReplacementGenerator() {
        this(0);
    }

    @ScriptMethodDocumentation(args="int", usage="height of the sea in the dimension", notes="This constructs a BiomeBlockReplacementGenerator. Sea height is required to properly handle replacement above/below the sea.")
    public BiomeBlockReplacementGenerator(int seaHeight) {
        this.seaHeight = seaHeight;
    }

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
        Random rand = new Random(world.func_72905_C());
        this.surfaceNoise = new NoiseGeneratorPerlin(rand, 4);
        this.biomesForGeneration = world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.replaceBiomeBlocks(world, random, chunkX, chunkZ, primer, this.biomesForGeneration);
    }

    public void generateBiomeTerrain(Biome[] biomes, Random rand, ChunkPrimer primer, int chunkX, int chunkZ) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                IBlockState topBlock = biomes[x * 16 + z].field_76752_A;
                IBlockState fillerBlock = biomes[x * 16 + z].field_76753_B;
                int blocksToPlace = 4;
                boolean underFluid = false;
                for (int y = 255; y >= 0; --y) {
                    IBlockState state = primer.func_177856_a(chunkX * 16 + x & 0xF, y, chunkZ * 16 + z & 0xF);
                    if (state == AIR) {
                        blocksToPlace = 4;
                        underFluid = false;
                        continue;
                    }
                    if (state.func_177230_c() instanceof BlockLiquid || state.func_177230_c() instanceof BlockFluidBase) {
                        blocksToPlace = 4;
                        underFluid = true;
                        continue;
                    }
                    if (blocksToPlace > 3 && !underFluid) {
                        primer.func_177855_a(x, y, z, topBlock);
                        --blocksToPlace;
                    } else if (blocksToPlace > 0) {
                        primer.func_177855_a(x, y, z, fillerBlock);
                        --blocksToPlace;
                    }
                    underFluid = false;
                }
            }
        }
    }

    public void replaceBiomeBlocks(World world, Random random, int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                this.generateBiomeTerrain(biome, random, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    public void generateBiomeTerrain(Biome biome, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = this.seaHeight;
        IBlockState iblockstate = biome.field_76752_A;
        IBlockState iblockstate1 = biome.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (!(iblockstate2.func_177230_c() instanceof BlockFluidBase) && !(iblockstate2.func_177230_c() instanceof BlockLiquid)) {
                if (j == -1) {
                    if (k <= 0) {
                        iblockstate = AIR;
                        iblockstate1 = STONE;
                    } else if (j1 >= i - 4 && j1 <= i + 1) {
                        iblockstate = biome.field_76752_A;
                        iblockstate1 = biome.field_76753_B;
                    }
                    if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                        iblockstate = biome.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? ICE : WATER;
                    }
                    j = k;
                    if (j1 >= i - 1) {
                        chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                        continue;
                    }
                    if (j1 < i - 7 - k) {
                        iblockstate = AIR;
                        iblockstate1 = STONE;
                        chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                        continue;
                    }
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                    continue;
                }
                if (j <= 0) continue;
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
                j = rand.nextInt(4) + Math.max(0, j1 - 63);
                iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? RED_SANDSTONE : SANDSTONE;
                continue;
            }
            j = k;
        }
    }
}

