/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.noise.OpenSimplexNoiseGeneratorOctaves;
import com.bloodnbonesgaming.topography.util.noise.FastNoise;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.layer.GenLayer;

public class DuneTestGenerator
implements IGenerator {
    final FastNoise noise = new FastNoise();
    OpenSimplexNoiseGeneratorOctaves simplex;
    private IBlockState state = Blocks.field_150354_m.func_176223_P();

    public DuneTestGenerator(ItemBlockData data) throws Exception {
        this.state = data.buildBlockState();
    }

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
        this.noise.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
        this.noise.SetFrequency(0.0035f);
        this.noise.SetFractalOctaves(2);
        this.noise.SetFractalType(FastNoise.FractalType.RigidMulti);
        this.noise.SetSeed((int)world.func_72905_C());
        this.noise.SetFractalGain(0.25f);
        this.simplex = new OpenSimplexNoiseGeneratorOctaves(world.func_72905_C());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 128; ++y) {
                    float skew = (float)this.simplex.eval((double)(x + chunkX * 16), (double)y, (double)(z + chunkZ * 16), 64.0, 4, 0.5);
                    float value = (this.noise.GetNoise((float)(x + chunkX * 16) + skew * 32.0f, (float)(z + chunkZ * 16) + skew * 32.0f) + 1.0f) / 2.0f;
                    if (!(value * 64.0f >= (float)y)) continue;
                    primer.func_177855_a(x, y, z, this.state);
                }
            }
        }
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random random) {
    }

    @Override
    public GenLayer getLayer(World world, GenLayer parent) {
        return null;
    }
}

