/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.util.noise.vanilla.VanillaNoiseGeneratorOctaves;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/OverworldGenerator", classExplaination="This file is for the OverworldGenerator. This generator generates a slightly more configurable version of the vanilla overworld, handling the generation of base terrain/water blocks and biome block replacement. This generator makes use of multithreaded noise generators to improve chunk generation speeds. Unfortunately, using these noise generators means the terrain will be slightly different to vanilla. Created using 'new OverworldGenerator()'.")
public class OverworldGenerator
implements IGenerator {
    public NoiseGeneratorOctaves minLimitPerlinNoise;
    public NoiseGeneratorOctaves maxLimitPerlinNoise;
    public NoiseGeneratorOctaves mainPerlinNoise;
    public NoiseGeneratorPerlin surfaceNoise;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    public NoiseGeneratorOctaves forestNoise;
    public final double[] heightMap;
    public final float[] biomeWeights;
    public ChunkGeneratorSettings settings;
    public double[] depthBuffer = new double[256];
    public Biome[] biomesForGeneration;
    public double[] mainNoiseRegion;
    public double[] minLimitRegion;
    public double[] maxLimitRegion;
    public double[] depthRegion;
    private IBlockState state = Blocks.field_150348_b.func_176223_P();
    private IBlockState oceanBlock = Blocks.field_150355_j.func_176223_P();
    private boolean amplified = false;
    private int seaLevel = 63;
    private boolean biomeBlockReplacement = true;
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState RED_SANDSTONE = Blocks.field_180395_cM.func_176223_P();
    protected static final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();

    @ScriptMethodDocumentation(usage="", notes="This constructs an OverworldGenerator.")
    public OverworldGenerator() {
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.biomeWeights[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
        this.settings = ChunkGeneratorSettings.Factory.func_177865_a((String)"").func_177864_b();
    }

    @ScriptMethodDocumentation(args="String", usage="generator string", notes="Sets the vanilla generator settings string for the generator.")
    public void setGeneratorString(String string) {
        this.settings = ChunkGeneratorSettings.Factory.func_177865_a((String)string).func_177864_b();
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="block", notes="Sets the terrain block to be used for the generator.")
    public void setTerrainBlock(ItemBlockData data) throws Exception {
        this.state = data.buildBlockState();
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="block", notes="Sets the ocean block to be used for the generator.")
    public void setOceanBlock(ItemBlockData data) throws Exception {
        this.oceanBlock = data.buildBlockState();
    }

    @ScriptMethodDocumentation(usage="", notes="Sets the generator to generate amplified terrain, as per the vanilla amplified WorldType.")
    public void amplify() {
        this.amplified = true;
    }

    @ScriptMethodDocumentation(args="int", usage="sea level", notes="Sets the sea level for the generator.")
    public void setSeaLevel(int level) {
        this.seaLevel = level;
    }

    @ScriptMethodDocumentation(usage="", notes="Disables the generators biome block replacement.")
    public void disableBiomeBlockReplacement() {
        this.biomeBlockReplacement = false;
    }

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
        Random rand = new Random(world.func_72905_C());
        this.minLimitPerlinNoise = new VanillaNoiseGeneratorOctaves(rand, 16);
        this.maxLimitPerlinNoise = new VanillaNoiseGeneratorOctaves(rand, 16);
        this.mainPerlinNoise = new VanillaNoiseGeneratorOctaves(rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(rand, 4);
        this.scaleNoise = new VanillaNoiseGeneratorOctaves(rand, 10);
        this.depthNoise = new VanillaNoiseGeneratorOctaves(rand, 16);
        this.forestNoise = new VanillaNoiseGeneratorOctaves(rand, 8);
        this.setBlocksInChunk(world, chunkX, chunkZ, primer);
        if (this.biomeBlockReplacement) {
            this.biomesForGeneration = world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
            this.replaceBiomeBlocks(world, random, chunkX, chunkZ, primer, this.biomesForGeneration);
        }
    }

    public void setBlocksInChunk(World world, int x, int z, ChunkPrimer primer) {
        this.biomesForGeneration = world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.generateHeightmap(x * 4, 0, z * 4);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d1 = this.heightMap[i1 + i2];
                    double d2 = this.heightMap[j1 + i2];
                    double d3 = this.heightMap[k1 + i2];
                    double d4 = this.heightMap[l1 + i2];
                    double d5 = (this.heightMap[i1 + i2 + 1] - d1) * 0.125;
                    double d6 = (this.heightMap[j1 + i2 + 1] - d2) * 0.125;
                    double d7 = (this.heightMap[k1 + i2 + 1] - d3) * 0.125;
                    double d8 = (this.heightMap[l1 + i2 + 1] - d4) * 0.125;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d16 = (d11 - d10) * 0.25;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                lvt_45_1_ += d16;
                                if (d > 0.0) {
                                    primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, this.state);
                                    continue;
                                }
                                if (i2 * 8 + j2 >= this.seaLevel) continue;
                                primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, this.oceanBlock);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBiomeBlocks(World world, Random random, int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(world, random, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    public void generateBiomeTerrain(Biome biome, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = this.seaLevel;
        IBlockState iblockstate = biome.field_76752_A;
        IBlockState iblockstate1 = biome.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = AIR;
                    iblockstate1 = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = biome.field_76752_A;
                    iblockstate1 = biome.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = biome.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = AIR;
                    iblockstate1 = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? RED_SANDSTONE : SANDSTONE;
        }
    }

    public void generateHeightmap(int p_185978_1_, int p_185978_2_, int p_185978_3_) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, p_185978_1_, p_185978_3_, 5, 5, (double)this.settings.field_177808_e, (double)this.settings.field_177803_f, (double)this.settings.field_177804_g);
        float f = this.settings.field_177811_a;
        float f1 = this.settings.field_177809_b;
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, p_185978_1_, p_185978_2_, p_185978_3_, 5, 33, 5, (double)(f / this.settings.field_177825_h), (double)(f1 / this.settings.field_177827_i), (double)(f / this.settings.field_177821_j));
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, p_185978_1_, p_185978_2_, p_185978_3_, 5, 33, 5, (double)f, (double)f1, (double)f);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, p_185978_1_, p_185978_2_, p_185978_3_, 5, 33, 5, (double)f, (double)f1, (double)f);
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                Biome biome = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                for (int j1 = -2; j1 <= 2; ++j1) {
                    for (int k1 = -2; k1 <= 2; ++k1) {
                        Biome biome1 = this.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                        float f5 = this.settings.field_177813_n + biome1.func_185355_j() * this.settings.field_177819_m;
                        float f6 = this.settings.field_177843_p + biome1.func_185360_m() * this.settings.field_177815_o;
                        if (this.amplified && f5 > 0.0f) {
                            f5 = 1.0f + f5 * 2.0f;
                            f6 = 1.0f + f6 * 4.0f;
                        }
                        float f7 = this.biomeWeights[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            f7 /= 2.0f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d7 = this.depthRegion[j] / 8000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 += d7 * 0.2;
                d8 = d8 * (double)this.settings.field_177823_k / 8.0;
                double d0 = (double)this.settings.field_177823_k + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * (double)this.settings.field_177817_l * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = this.minLimitRegion[i] / (double)this.settings.field_177806_d;
                    double d3 = this.maxLimitRegion[i] / (double)this.settings.field_177810_c;
                    double d4 = (this.mainNoiseRegion[i] / 10.0 + 1.0) / 2.0;
                    double d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) + -10.0 * d6;
                    }
                    this.heightMap[i] = d5;
                    ++i;
                }
            }
        }
    }
}

