/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cxlibrary.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MultiBakedModel
implements IBakedModel {
    private final Map<BiPredicate<IBlockState, EnumFacing>, IBakedModel> selectors;
    protected final boolean ambientOcclusion;
    protected final boolean gui3D;
    protected final TextureAtlasSprite particleTexture;
    protected final ItemCameraTransforms cameraTransforms;
    protected final ItemOverrideList overrides;

    public MultiBakedModel(Map<BiPredicate<IBlockState, EnumFacing>, IBakedModel> selectorsIn) {
        this.selectors = selectorsIn;
        IBakedModel ibakedmodel = selectorsIn.values().iterator().next();
        this.ambientOcclusion = ibakedmodel.func_177555_b();
        this.gui3D = ibakedmodel.func_177556_c();
        this.particleTexture = ibakedmodel.func_177554_e();
        this.cameraTransforms = ibakedmodel.func_177552_f();
        this.overrides = ibakedmodel.func_188617_f();
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        ArrayList list = Lists.newArrayList();
        if (state != null && side != null) {
            for (Map.Entry<BiPredicate<IBlockState, EnumFacing>, IBakedModel> entry : this.selectors.entrySet()) {
                if (!entry.getKey().test(state, side)) continue;
                list.addAll(entry.getValue().func_188616_a(state, side, rand++));
            }
        }
        return list;
    }

    public boolean func_177555_b() {
        return this.ambientOcclusion;
    }

    public boolean func_177556_c() {
        return this.gui3D;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleTexture;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.cameraTransforms;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Builder {
        private Map<BiPredicate<IBlockState, EnumFacing>, IBakedModel> builderSelectors = Maps.newLinkedHashMap();

        public Builder putModel(BiPredicate<IBlockState, EnumFacing> selector, IBakedModel model) {
            this.builderSelectors.put(selector, model);
            return this;
        }

        public IBakedModel build() {
            return new MultiBakedModel(this.builderSelectors);
        }
    }
}

