/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel.gui;

import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.ContainerEnderCap;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.block.darksteel.anvil.BlockDarkSteelAnvil;
import crazypants.enderio.base.handler.darksteel.gui.AnvilSubContainer;
import crazypants.enderio.base.handler.darksteel.gui.DSURemoteExec;
import crazypants.enderio.base.handler.darksteel.gui.ISlotSelector;
import crazypants.enderio.base.handler.darksteel.gui.SlotSelector;
import crazypants.enderio.base.handler.darksteel.gui.UpgradeCap;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.darksteel.upgrade.anvil.AnvilUpgrade;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.material.upgrades.ItemUpgrades;
import crazypants.enderio.util.EIOCombinedInvWrapper;
import crazypants.enderio.util.Prep;
import crazypants.enderio.util.WorldTarget;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class DSUContainer
extends ContainerEnderCap<EIOCombinedInvWrapper<UpgradeCap>, TileEntity>
implements DSURemoteExec.Container {
    private static final int X0 = 8;
    private static final int Y0 = 10;
    private static final int COLS = 9;
    protected ISlotSelector activeTab = SlotSelector.CHEST;
    protected final SlotInventory slotInventory = new SlotInventory();
    protected final AnvilSubContainer anvil;
    protected final NNList<UpgradeCap> caps;
    protected final WorldTarget target;
    @Nullable
    protected final BlockDarkSteelAnvil block;
    private final NNList<AutoSlot> autoSlots = new NNList();
    private int guid = 0;

    @Nullable
    public static DSUContainer create(EntityPlayer player, World world, BlockPos pos, @Nullable EnumFacing facing, int param1, @Nullable BlockDarkSteelAnvil block) {
        NNList caps = new NNList();
        WorldTarget target = WorldTarget.TRUE;
        if (pos.func_177956_o() >= 0 && world.func_175667_e(pos) && world.func_180495_p(pos).func_177230_c() == block) {
            target = WorldTarget.ofBlock(world, pos, (Block)block);
            caps.add((Object)new UpgradeCap(SlotSelector.ANVIL, player, false));
            NNList.of(SlotSelector.class).apply(ss -> caps.add((Object)new UpgradeCap((ISlotSelector)ss, player, false)));
            caps.add((Object)new UpgradeCap(new SlotSelector.SlotItem(), player, false));
        } else {
            AnvilUpgrade highestEquipped = AnvilUpgrade.getHighestEquippedUpgrade(player);
            if (highestEquipped != null && highestEquipped.allowsAnvilRecipes()) {
                caps.add((Object)new UpgradeCap(SlotSelector.ANVIL, player, false));
            }
            if (highestEquipped != null && highestEquipped.allowsEditingOtherEquippedItems()) {
                NNList.of(SlotSelector.class).apply(ss -> caps.add((Object)new UpgradeCap((ISlotSelector)ss, player, false)));
            } else if (player.func_184614_ca().func_77973_b() == ModObject.itemDarkSteelUpgrade.getItemNN()) {
                NNList.of(SlotSelector.class).forEach(ss -> {
                    if (ss.getSlot() != EntityEquipmentSlot.MAINHAND) {
                        caps.add((Object)new UpgradeCap((ISlotSelector)ss, player, AnvilUpgrade.loadAnyFromItem(ss.getItem(player)) == null));
                    }
                });
            } else if (player.func_184592_cb().func_77973_b() == ModObject.itemDarkSteelUpgrade.getItemNN()) {
                NNList.of(SlotSelector.class).forEach(ss -> {
                    if (ss.getSlot() != EntityEquipmentSlot.OFFHAND) {
                        caps.add((Object)new UpgradeCap((ISlotSelector)ss, player, AnvilUpgrade.loadAnyFromItem(ss.getItem(player)) == null));
                    }
                });
            } else {
                NNList.of(SlotSelector.class).apply(ss -> {
                    if (AnvilUpgrade.loadAnyFromItem(ss.getItem(player)) != null) {
                        caps.add((Object)new UpgradeCap((ISlotSelector)ss, player, false));
                    }
                });
            }
            if (highestEquipped != null && highestEquipped.allowsEditingSlotItems()) {
                caps.add((Object)new UpgradeCap(new SlotSelector.SlotItem(), player, false));
            }
        }
        for (UpgradeCap cap : caps) {
            if (cap.getSlotSelector().isSlot() && !cap.isAvailable()) continue;
            return (DSUContainer)new DSUContainer(player, (NNList<UpgradeCap>)caps, target, block).init();
        }
        if (!player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)Lang.DSU_GUI_NO_ITEMS.toChatServer(), true);
        }
        return null;
    }

    public DSUContainer(EntityPlayer player, NNList<UpgradeCap> caps, WorldTarget target, @Nullable BlockDarkSteelAnvil block) {
        super(player.field_71071_by, (IItemHandler)new EIOCombinedInvWrapper((IItemHandlerModifiable[])caps.toArray((Object[])new UpgradeCap[0])), null, true);
        this.caps = caps;
        this.anvil = new AnvilSubContainer(this, player);
        this.target = target;
        this.block = block;
    }

    protected void addSlots() {
        int i;
        this.anvil.addSlots();
        this.autoSlots.clear();
        for (i = 0; i < ((EIOCombinedInvWrapper)this.getItemHandler()).getSlots(); ++i) {
            this.autoSlots.add((Object)((AutoSlot)this.func_75146_a((Slot)new AutoSlot(this.getItemHandler(), i, 0, 0, false))));
        }
        i = 0;
        for (UpgradeCap cap : this.caps) {
            if (!cap.getSlotSelector().isItem()) continue;
            this.func_75146_a(cap.getSlotSelector().setContainerSlot(new Slot((IInventory)this.slotInventory, i++, 0, 0){

                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return this.field_75224_c.func_94041_b(this.getSlotIndex(), stack);
                }
            }));
        }
    }

    protected void calcSlots() {
        int y = 0;
        int x = 0;
        ISlotSelector last = null;
        for (int i = 0; i < ((EIOCombinedInvWrapper)this.getItemHandler()).getSlots(); ++i) {
            int idx;
            UpgradeCap handler = (UpgradeCap)((EIOCombinedInvWrapper)this.getItemHandler()).getHandlerFromSlot(i);
            if (!handler.isVisible(idx = ((EIOCombinedInvWrapper)this.getItemHandler()).getIndexForHandler(i))) continue;
            ISlotSelector current = handler.getSlotSelector();
            AutoSlot slot = (AutoSlot)((Object)this.autoSlots.get(i));
            slot.noHead = false;
            if (current != last) {
                x = 0;
                y = 0;
                last = current;
                slot.noHead = true;
            } else if (handler.isHead(idx)) {
                if (handler.isInventorySlot(idx)) {
                    x = 0;
                    y = 90;
                    slot.noHead = true;
                } else {
                    x += 6;
                }
            }
            if (x > 144) {
                x = 0;
                y += 24;
                slot.noHead = true;
            }
            slot.field_75223_e = 8 + x;
            slot.field_75221_f = 10 + y;
            x += 18;
        }
    }

    public void createGhostSlots(List<GhostSlot> slots) {
        for (Slot slot : this.getSlotLocations().keySet()) {
            if (!(slot instanceof AutoSlot)) continue;
            slots.add((GhostSlot)new UpgradeSlot(Prep.getEmpty(), (AutoSlot)slot));
        }
    }

    @Nonnull
    public Point getPlayerInventoryOffset() {
        Point p = super.getPlayerInventoryOffset();
        p.translate(8, 70);
        return p;
    }

    @Override
    public void setGuiID(int id) {
        this.guid = id;
    }

    @Override
    public int getGuiID() {
        return this.guid;
    }

    @Override
    @Nonnull
    public ISlotSelector setTab(int tab) {
        for (UpgradeCap cap : this.caps) {
            if (cap.getSlotSelector().getTabOrder() != tab) continue;
            this.activeTab = cap.getSlotSelector();
            return this.activeTab;
        }
        return this.activeTab;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return this.target.isValid(player, 64.0) && this.caps.stream().anyMatch(UpgradeCap::isStillConnectedToPlayer);
    }

    public void func_75134_a(@Nonnull EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.anvil.onContainerClosed(playerIn);
        if (!playerIn.field_70170_p.field_72995_K) {
            this.func_193327_a(playerIn, playerIn.field_70170_p, (IInventory)this.slotInventory);
        }
    }

    @Nonnull
    protected Slot func_75146_a(@Nonnull Slot slotIn) {
        return super.func_75146_a(slotIn);
    }

    protected void func_193327_a(@Nonnull EntityPlayer playerIn, @Nonnull World worldIn, @Nonnull IInventory inventoryIn) {
        super.func_193327_a(playerIn, worldIn, inventoryIn);
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        this.anvil.addListener(listener);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        this.anvil.updateProgressBar(id, data);
    }

    @Override
    public void updateItemName(@Nonnull String newName) {
        this.anvil.updateItemName(newName);
    }

    @Nonnull
    protected Collection<Slot> mapSlotToTargets(int fromSlotId) {
        Slot fromSlot = (Slot)this.field_75151_b.get(fromSlotId);
        if (fromSlot instanceof AutoSlot) {
            boolean isInventory = ((AutoSlot)fromSlot).isInventorySlot();
            ArrayList<Slot> result = new ArrayList<Slot>();
            for (int i = 0; i < this.startPlayerSlot; ++i) {
                Slot toSlot = (Slot)this.field_75151_b.get(i);
                if (!(toSlot instanceof AutoSlot) || isInventory == ((AutoSlot)toSlot).isInventorySlot()) continue;
                result.add(toSlot);
            }
            result.addAll(super.mapSlotToTargets(fromSlotId));
            return result;
        }
        return super.mapSlotToTargets(fromSlotId);
    }

    private class SlotInventory
    extends InventoryBasic {
        public SlotInventory() {
            super("", false, 7);
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof IDarkSteelItem;
        }
    }

    final class AutoSlot
    extends ContainerEnderCap.BaseSlotItemHandler {
        boolean noHead;

        AutoSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, boolean noHead) {
            super(itemHandler, index, xPosition, yPosition);
            this.noHead = noHead;
        }

        public boolean isBlocked() {
            return this.getHandler().isSlotBlocked(this.getHandlerSlot());
        }

        public List<ITextComponent> getSlotBlockedReason() {
            return this.getHandler().getSlotBlockedReason(this.getHandlerSlot());
        }

        public boolean isHead() {
            return this.getHandler().isHead(this.getHandlerSlot()) && !this.noHead;
        }

        public boolean isLocked() {
            return this.getHandler().isLocked(this.getHandlerSlot());
        }

        private int getHandlerSlot() {
            return ((EIOCombinedInvWrapper)this.getItemHandler()).getIndexForHandler(this.getSlotIndex());
        }

        private UpgradeCap getHandler() {
            return (UpgradeCap)((EIOCombinedInvWrapper)this.getItemHandler()).getHandlerFromSlot(this.getSlotIndex());
        }

        public boolean func_111238_b() {
            return DSUContainer.this.activeTab == this.getHandler().getSlotSelector() && this.getHandler().isVisible(this.getHandlerSlot());
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return this.func_111238_b() && this.getHandler().isItemValid(this.getHandlerSlot(), stack);
        }

        public int func_178170_b(ItemStack stack) {
            return this.getHandler().getSlotLimit(this.getHandlerSlot());
        }

        ItemStack getUpgradeItem() {
            return this.getHandler().getUpgradeItem(this.getHandlerSlot());
        }

        boolean isInventorySlot() {
            return this.getHandler().isInventorySlot(this.getHandlerSlot());
        }

        public int getX() {
            return this.field_75223_e;
        }

        public int getY() {
            return this.field_75221_f;
        }
    }

    static final class UpgradeSlot
    extends GhostBackgroundItemSlot {
        private final AutoSlot slot;

        UpgradeSlot(ItemStack stack, AutoSlot parent) {
            super(stack, (Slot)parent);
            this.slot = parent;
        }

        @Nonnull
        public ItemStack getStack() {
            return ItemUpgrades.setEnabled(this.slot.getUpgradeItem(), false);
        }

        public boolean isVisible() {
            return this.slot.func_111238_b() && super.isVisible();
        }

        public boolean isMouseOver(int mx, int my) {
            return !this.slot.isInventorySlot() && mx >= this.getX() && mx < this.getX() + 16 && my >= this.getY() && my < this.getY() + 16;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean drawGhostSlotToolTip(@Nonnull GuiContainerBase gui, int mouseX, int mouseY) {
            if (gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                List<ITextComponent> reason;
                NNList text = new NNList((Object[])new String[]{this.getStack().func_82833_r()});
                if (this.slot.isBlocked() && !(reason = this.slot.getSlotBlockedReason()).isEmpty()) {
                    text.add("");
                    text.addAll(reason.stream().peek(itc -> itc.func_150256_b().func_150238_a(TextFormatting.DARK_RED)).map(ITextComponent::func_150254_d).collect(Collectors.toList()));
                }
                GuiUtils.drawHoveringText((ItemStack)Prep.getEmpty(), (List)text, (int)mouseX, (int)mouseY, (int)gui.field_146294_l, (int)gui.field_146295_m, (int)-1, (FontRenderer)gui.getFontRenderer());
                return true;
            }
            return false;
        }
    }
}

