/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.csg.lib;

import com.brandon3055.csg.LogHelper;
import com.google.common.base.Objects;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class StackReference {
    private ResourceLocation stack;
    protected int metadata = 0;
    protected int stackSize = 0;
    protected NBTTagCompound nbt = null;

    public StackReference(String stackRegName, int stackSize, int metadata, NBTTagCompound nbt) {
        this.stack = new ResourceLocation(stackRegName);
        this.metadata = metadata;
        this.stackSize = stackSize;
        this.nbt = nbt;
        if (stackSize <= 0) {
            this.stackSize = 1;
        }
    }

    public StackReference(String stackRegName, int stackSize, int metadata) {
        this(stackRegName, stackSize, metadata, null);
    }

    public StackReference(String stackRegName, int stackSize) {
        this(stackRegName, stackSize, 0);
    }

    public StackReference(String stackRegName) {
        this(stackRegName, 1);
    }

    public StackReference(ItemStack stack) {
        this(stack.func_77973_b().getRegistryName().toString(), stack.func_190916_E(), stack.func_77952_i(), stack.func_77978_p());
    }

    private StackReference() {
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.stack, this.stackSize, this.metadata, this.nbt});
    }

    public ItemStack createStack() {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)this.stack);
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)this.stack);
        if (item == null && block == Blocks.field_150350_a) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = item != null ? new ItemStack(item, this.stackSize, this.metadata) : new ItemStack(block, this.stackSize, this.metadata);
        if (this.nbt != null) {
            itemStack.func_77982_d(this.nbt.func_74737_b());
        }
        return itemStack;
    }

    public String toString() {
        if (this.nbt == null) {
            if (this.metadata == 0) {
                if (this.stackSize == 1) {
                    return this.stack.toString();
                }
                return this.stack + "," + this.stackSize;
            }
            return this.stack + "," + this.stackSize + "," + this.metadata;
        }
        return this.stack + "," + this.stackSize + "," + this.metadata + "," + this.nbt.toString();
    }

    public static StackReference fromString(String string) {
        String stackString;
        if (string.contains("name:") && string.contains("size:")) {
            return StackReference.fromStringOld(string);
        }
        String workString = string;
        String splitter = ",";
        String countString = "";
        String metaString = "";
        String nbt = "";
        if (!workString.contains(splitter)) {
            stackString = workString;
            workString = "";
        } else {
            stackString = workString.substring(0, workString.indexOf(splitter));
            workString = workString.substring(workString.indexOf(splitter) + splitter.length());
        }
        if (!stackString.contains(":")) {
            LogHelper.warn("StackReference: Was given an invalid stack string. String did not contain \":\" - " + string);
            return null;
        }
        if (workString.length() > 0) {
            if (!workString.contains(splitter)) {
                countString = workString;
                workString = "";
            } else {
                countString = workString.substring(0, workString.indexOf(splitter));
                workString = workString.substring(workString.indexOf(splitter) + splitter.length());
            }
        }
        if (workString.length() > 0) {
            if (!workString.contains(splitter)) {
                metaString = workString;
                workString = "";
            } else {
                metaString = workString.substring(0, workString.indexOf(splitter));
                workString = workString.substring(workString.indexOf(splitter) + splitter.length());
            }
        }
        if (workString.length() > 0) {
            nbt = workString;
        }
        int count = 1;
        int meta = 0;
        NBTTagCompound compound = null;
        if (countString.length() > 0) {
            try {
                count = Integer.parseInt(countString);
            }
            catch (Exception e) {
                LogHelper.warn("StackReference: Failed to parse stack size from string - " + countString + " error: " + e.getMessage());
            }
        }
        if (metaString.length() > 0) {
            try {
                meta = Integer.parseInt(metaString);
            }
            catch (Exception e) {
                LogHelper.warn("StackReference: Failed to parse stack meta from string - " + metaString + " error: " + e.getMessage());
            }
        }
        if (nbt.length() > 0) {
            try {
                compound = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (Exception e) {
                LogHelper.warn("StackReference: Failed to parse stack nbt from string - " + nbt + " error: " + e.getMessage());
            }
        }
        return new StackReference(stackString, count, meta, compound);
    }

    private static StackReference fromStringOld(String string) {
        if (!(string.contains("name:") && string.contains("size:") && string.contains(",meta:") && string.contains(",nbt:"))) {
            return null;
        }
        try {
            String name = string.substring(5, string.indexOf(",size:"));
            int size = Integer.parseInt(string.substring(string.indexOf(",size:") + 6, string.indexOf(",meta:")));
            int meta = Integer.parseInt(string.substring(string.indexOf(",meta:") + 6, string.indexOf(",nbt:")));
            NBTTagCompound compound = JsonToNBT.func_180713_a((String)string.substring(string.indexOf(",nbt:") + 5, string.length()));
            return new StackReference(name, size, meta, compound.func_82582_d() ? null : compound);
        }
        catch (Exception e) {
            LogHelper.error("An error occurred while generating a StackReference from a string");
            e.printStackTrace();
            return null;
        }
    }
}

