/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tile;

import com.blakebr0.cucumber.energy.EnergyStorageCustom;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.util.VanillaPacketDispatcher;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.CompressorRecipe;
import com.blakebr0.extendedcrafting.crafting.CompressorRecipeManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileCompressor
extends TileEntity
implements ISidedInventory,
ITickable {
    private NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private final EnergyStorageCustom energy = new EnergyStorageCustom(ModConfig.confCompressorRFCapacity);
    private ItemStack materialStack = ItemStack.field_190927_a;
    private int materialCount;
    private int progress;
    private boolean ejecting = false;
    private int oldEnergy;
    private boolean inputLimit = true;

    private List<CompressorRecipe> getValidRecipes(ItemStack stack) {
        ArrayList<CompressorRecipe> valid = new ArrayList<CompressorRecipe>();
        if (!stack.func_190926_b()) {
            for (CompressorRecipe recipe : CompressorRecipeManager.getInstance().getRecipes()) {
                Object input = recipe.getInput();
                if (input instanceof ItemStack) {
                    ItemStack inputStack = (ItemStack)input;
                    if (inputStack.func_77952_i() == Short.MAX_VALUE && inputStack.func_77973_b() == stack.func_77973_b()) {
                        valid.add(recipe);
                    }
                    if (!inputStack.func_77969_a(stack) || !StackHelper.compareTags((ItemStack)inputStack, (ItemStack)stack)) continue;
                    valid.add(recipe);
                    continue;
                }
                if (!(input instanceof List)) continue;
                for (ItemStack next : (List)input) {
                    if (next.func_77960_j() != Short.MAX_VALUE && next.func_77960_j() != stack.func_77960_j() || next.func_77973_b() != stack.func_77973_b()) continue;
                    valid.add(recipe);
                }
            }
        }
        return valid;
    }

    public void func_73660_a() {
        boolean mark = false;
        if (!this.func_145831_w().field_72995_K) {
            CompressorRecipe recipe = this.getRecipe();
            ItemStack output = this.func_70301_a(0);
            ItemStack input = this.func_70301_a(1);
            if (!input.func_190926_b()) {
                if (this.materialStack.func_190926_b()) {
                    this.materialStack = input.func_77946_l();
                    if (!mark) {
                        mark = true;
                    }
                }
                if ((!this.inputLimit || recipe != null && this.materialCount < recipe.getInputCount()) && StackHelper.areStacksEqual((ItemStack)input, (ItemStack)this.materialStack)) {
                    int consumeAmount = input.func_190916_E();
                    if (this.inputLimit) {
                        consumeAmount = Math.min(consumeAmount, recipe.getInputCount() - this.materialCount);
                    }
                    StackHelper.decrease((ItemStack)input, (int)consumeAmount, (boolean)false);
                    this.materialCount += consumeAmount;
                    if (!mark) {
                        mark = true;
                    }
                }
            }
            if (recipe != null && this.getEnergy().getEnergyStored() > 0 && this.materialCount >= recipe.getInputCount()) {
                this.process(recipe);
                if (this.progress == recipe.getPowerCost()) {
                    ItemStack recipeOutput = recipe.getOutput();
                    if ((output.func_190926_b() || StackHelper.areStacksEqual((ItemStack)output, (ItemStack)recipeOutput)) && output.func_190916_E() < recipeOutput.func_77976_d()) {
                        this.addStackToSlot(0, recipe.getOutput());
                        if (recipe.consumeCatalyst()) {
                            StackHelper.decrease((ItemStack)this.func_70301_a(2), (int)1, (boolean)false);
                        }
                        this.progress = 0;
                        this.materialCount -= recipe.getInputCount();
                        if (this.materialCount <= 0) {
                            this.materialStack = ItemStack.field_190927_a;
                        }
                    }
                }
            }
            if (this.ejecting && this.materialCount > 0 && !this.materialStack.func_190926_b()) {
                ItemStack toAdd = this.materialStack.func_77946_l();
                int addCount = Math.min(this.materialCount, toAdd.func_77976_d());
                toAdd.func_190920_e(addCount);
                int added = this.addStackToSlot(0, toAdd);
                if (added > 0) {
                    this.materialCount -= added;
                    if (this.materialCount < 1) {
                        this.materialStack = ItemStack.field_190927_a;
                        this.ejecting = false;
                    }
                    if (this.progress > 0) {
                        this.progress = 0;
                    }
                    if (!mark) {
                        mark = true;
                    }
                }
            }
        }
        if (this.oldEnergy != this.energy.getEnergyStored()) {
            this.oldEnergy = this.energy.getEnergyStored();
            if (!mark) {
                mark = true;
            }
        }
        if (mark) {
            this.func_70296_d();
        }
    }

    public CompressorRecipe getRecipe() {
        List<CompressorRecipe> recipes = this.getValidRecipes(this.materialStack);
        if (!recipes.isEmpty()) {
            for (CompressorRecipe recipe : recipes) {
                ItemStack mat = this.materialStack;
                Object input = recipe.getInput();
                if (input instanceof ItemStack) {
                    if (!StackHelper.areItemsEqual((ItemStack)((ItemStack)input), (ItemStack)mat, (boolean)true) || !this.func_70301_a(2).func_77969_a(recipe.getCatalyst())) continue;
                    return recipe;
                }
                if (!(input instanceof List)) continue;
                for (ItemStack next : (List)input) {
                    if (!StackHelper.areItemsEqual((ItemStack)next, (ItemStack)mat, (boolean)true) || !this.func_70301_a(2).func_77969_a(recipe.getCatalyst())) continue;
                    return recipe;
                }
            }
        }
        return null;
    }

    private boolean process(CompressorRecipe recipe) {
        int extract = recipe.getPowerRate();
        int difference = recipe.getPowerCost() - this.progress;
        if (difference < extract) {
            extract = difference;
        }
        int extracted = this.getEnergy().extractEnergy(extract, false);
        this.progress += extracted;
        return this.progress >= recipe.getPowerCost();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventoryStacks);
        compound.func_74768_a("MaterialCount", this.materialCount);
        if (this.materialStack == null) {
            this.materialStack = ItemStack.field_190927_a;
        }
        if (!this.materialStack.func_190926_b()) {
            compound.func_74782_a("MaterialStack", (NBTBase)this.materialStack.serializeNBT());
        }
        compound.func_74768_a("Progress", this.progress);
        compound.func_74757_a("Ejecting", this.ejecting);
        compound.func_74768_a("Energy", this.energy.getEnergyStored());
        compound.func_74757_a("InputLimit", this.inputLimit);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventoryStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventoryStacks);
        this.materialCount = compound.func_74762_e("MaterialCount");
        this.materialStack = new ItemStack(compound.func_74775_l("MaterialStack"));
        this.progress = compound.func_74762_e("Progress");
        this.ejecting = compound.func_74767_n("Ejecting");
        this.energy.setEnergy(compound.func_74762_e("Energy"));
        this.inputLimit = compound.func_74767_n("InputLimit");
    }

    public int addStackToSlot(int slot, ItemStack stack) {
        ItemStack slotStack = this.func_70301_a(slot);
        if (slotStack.func_190926_b()) {
            this.func_70299_a(slot, stack);
            return stack.func_190916_E();
        }
        if (StackHelper.areStacksEqual((ItemStack)stack, (ItemStack)slotStack) && slotStack.func_190916_E() < slotStack.func_77976_d()) {
            ItemStack newStack = slotStack.func_77946_l();
            int newSize = Math.min(slotStack.func_190916_E() + stack.func_190916_E(), slotStack.func_77976_d());
            newStack.func_190920_e(newSize);
            this.func_70299_a(slot, newStack);
            return newSize - slotStack.func_190916_E();
        }
        return 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public EnergyStorageCustom getEnergy() {
        return this.energy;
    }

    public ItemStack getMaterialStack() {
        return this.materialStack;
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void toggleEjecting() {
        if (this.materialCount > 0) {
            this.ejecting = !this.ejecting;
            this.func_70296_d();
        }
    }

    public boolean isLimitingInput() {
        return this.inputLimit;
    }

    public void toggleInputLimit() {
        this.inputLimit = !this.inputLimit;
        this.func_70296_d();
    }

    public int getProgress() {
        return this.progress;
    }

    public int func_70302_i_() {
        return this.inventoryStacks.size();
    }

    public boolean func_191420_l() {
        return this.inventoryStacks.stream().allMatch(ItemStack::func_190926_b);
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventoryStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventoryStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventoryStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventoryStacks.get(index);
        boolean flag = !stack.func_190926_b() && StackHelper.areStacksEqual((ItemStack)stack, (ItemStack)itemstack);
        this.inventoryStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        return index != 0;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else if (side == EnumFacing.UP) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        } else {
            int[] nArray4 = new int[2];
            nArray4[0] = 0;
            nArray = nArray4;
            nArray4[1] = 1;
        }
        return nArray;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return this.getCapability(capability, side) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new SidedInvWrapper((ISidedInventory)this, facing);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        return (T)super.getCapability(capability, facing);
    }
}

