/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.SizedTextureArea;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.AbstractPositionedRectangleWidget;
import gregtech.api.util.GTUtility;
import gregtech.api.util.function.BooleanConsumer;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CycleButtonWidget
extends AbstractPositionedRectangleWidget {
    protected TextureArea buttonTexture = GuiTextures.VANILLA_BUTTON.getSubArea(0.0, 0.0, 1.0, 0.5);
    private String[] optionNames;
    private int textColor = 0xFFFFFF;
    private IntSupplier currentOptionSupplier;
    private IntConsumer setOptionExecutor;
    protected int currentOption;
    protected String tooltipHoverString;
    protected long hoverStartTime = -1L;
    protected boolean isMouseHovered;

    public CycleButtonWidget(int xPosition, int yPosition, int width, int height, String[] optionNames, IntSupplier currentOptionSupplier, IntConsumer setOptionExecutor) {
        super(xPosition, yPosition, width, height);
        this.optionNames = optionNames;
        this.currentOptionSupplier = currentOptionSupplier;
        this.setOptionExecutor = setOptionExecutor;
    }

    public <T extends Enum<T>> CycleButtonWidget(int xPosition, int yPosition, int width, int height, Class<T> enumClass, Supplier<T> supplier, Consumer<T> updater) {
        super(xPosition, yPosition, width, height);
        Enum[] enumConstantPool = (Enum[])enumClass.getEnumConstants();
        this.optionNames = GTUtility.mapToString(enumConstantPool, it -> ((IStringSerializable)it).func_176610_l());
        this.currentOptionSupplier = () -> ((Enum)supplier.get()).ordinal();
        this.setOptionExecutor = newIndex -> updater.accept(enumConstantPool[newIndex]);
    }

    public CycleButtonWidget(int xPosition, int yPosition, int width, int height, BooleanSupplier supplier, BooleanConsumer updater, String ... optionNames) {
        super(xPosition, yPosition, width, height);
        this.optionNames = optionNames;
        this.currentOptionSupplier = () -> supplier.getAsBoolean() ? 1 : 0;
        this.setOptionExecutor = value -> updater.apply(value >= 1);
    }

    public CycleButtonWidget setTooltipHoverString(String hoverString) {
        this.tooltipHoverString = hoverString;
        return this;
    }

    public CycleButtonWidget setButtonTexture(TextureArea texture) {
        this.buttonTexture = texture;
        return this;
    }

    public CycleButtonWidget setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY) {
        if (this.buttonTexture instanceof SizedTextureArea) {
            ((SizedTextureArea)this.buttonTexture).drawHorizontalCutSubArea(this.xPosition, this.yPosition, this.width, this.height, 0.0, 1.0);
        } else {
            this.buttonTexture.drawSubArea(this.xPosition, this.yPosition, this.width, this.height, 0.0, 0.0, 1.0, 1.0);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String text = I18n.func_135052_a((String)this.optionNames[this.currentOption], (Object[])new Object[0]);
        fontRenderer.func_78276_b(text, this.xPosition + this.width / 2 - fontRenderer.func_78256_a(text) / 2, this.yPosition + this.height / 2 - fontRenderer.field_78288_b / 2, this.textColor);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        long timeSinceHover;
        boolean isHovered = CycleButtonWidget.isMouseOver(this.xPosition, this.yPosition, this.width, this.height, mouseX, mouseY);
        boolean wasHovered = this.isMouseHovered;
        if (isHovered && !wasHovered) {
            this.isMouseHovered = true;
            this.hoverStartTime = System.currentTimeMillis();
        } else if (!isHovered && wasHovered) {
            this.isMouseHovered = false;
            this.hoverStartTime = 0L;
        } else if (isHovered && (timeSinceHover = System.currentTimeMillis() - this.hoverStartTime) > 1000L && this.tooltipHoverString != null) {
            List<String> hoverList = Arrays.asList(I18n.func_135052_a((String)this.tooltipHoverString, (Object[])new Object[0]).split("/n"));
            this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.currentOptionSupplier.getAsInt() != this.currentOption) {
            this.currentOption = this.currentOptionSupplier.getAsInt();
            this.writeUpdateInfo(1, buf -> buf.func_150787_b(this.currentOption));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.currentOption = buffer.func_150792_a();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        if (CycleButtonWidget.isMouseOver(this.xPosition, this.yPosition, this.width, this.height, mouseX, mouseY)) {
            this.currentOption = (this.currentOption + 1) % this.optionNames.length;
            this.writeClientAction(1, buf -> buf.func_150787_b(this.currentOption));
            this.playButtonClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            this.currentOption = MathHelper.func_76125_a((int)buffer.func_150792_a(), (int)0, (int)this.optionNames.length);
            this.setOptionExecutor.accept(this.currentOption);
        }
    }
}

