/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.gui;

import com.google.common.base.Preconditions;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.gui.PlayerInventoryUIFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerInventoryHolder
implements IUIHolder {
    public final EntityPlayer player;
    final EnumHand hand;
    ItemStack sampleItem;

    @SideOnly(value=Side.CLIENT)
    PlayerInventoryHolder(EntityPlayer player, EnumHand hand, ItemStack sampleItem) {
        this.player = player;
        this.hand = hand;
        this.sampleItem = sampleItem;
    }

    public PlayerInventoryHolder(EntityPlayer entityPlayer, EnumHand hand) {
        this.player = entityPlayer;
        this.hand = hand;
        this.sampleItem = this.player.func_184586_b(hand);
        Preconditions.checkArgument((boolean)(this.sampleItem.func_77973_b() instanceof ItemUIFactory), (Object)"Current Item should implement ItemUIFactory");
    }

    public static void openHandItemUI(EntityPlayer player, EnumHand hand) {
        PlayerInventoryHolder holder = new PlayerInventoryHolder(player, hand);
        holder.openUI();
    }

    ModularUI createUI(EntityPlayer entityPlayer) {
        ItemUIFactory uiFactory = (ItemUIFactory)this.sampleItem.func_77973_b();
        return uiFactory.createUI(this, entityPlayer);
    }

    public void openUI() {
        PlayerInventoryUIFactory.INSTANCE.openUI(this, (EntityPlayerMP)this.player);
    }

    @Override
    public boolean isValid() {
        ItemStack itemStack = this.player.func_184586_b(this.hand);
        return ItemStack.func_179545_c((ItemStack)this.sampleItem, (ItemStack)itemStack);
    }

    @Override
    public boolean isRemote() {
        return this.player.func_130014_f_().field_72995_K;
    }

    public ItemStack getCurrentItem() {
        ItemStack itemStack = this.player.func_184586_b(this.hand);
        if (!ItemStack.func_179545_c((ItemStack)this.sampleItem, (ItemStack)itemStack)) {
            return null;
        }
        return itemStack;
    }

    public void setCurrentItem(ItemStack item) {
        ItemStack itemStack = this.player.func_184586_b(this.hand);
        if (!ItemStack.func_179545_c((ItemStack)this.sampleItem, (ItemStack)itemStack)) {
            return;
        }
        Preconditions.checkArgument((boolean)(item.func_77973_b() instanceof ItemUIFactory), (Object)"Current Item should implement ItemUIFactory");
        this.sampleItem = item;
        this.player.func_184611_a(this.hand, item);
    }

    @Override
    public void markAsDirty() {
        this.player.field_71071_by.func_70296_d();
        this.player.field_71069_bz.func_75142_b();
    }
}

