/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import com.google.common.collect.ImmutableMap;
import gnu.trove.map.TObjectIntMap;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.ValidationResult;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class FusionRecipeBuilder
extends RecipeBuilder<FusionRecipeBuilder> {
    private int EUToStart;

    public FusionRecipeBuilder() {
    }

    public FusionRecipeBuilder(Recipe recipe, RecipeMap<FusionRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
        this.EUToStart = recipe.getIntegerProperty("EUToStart");
    }

    public FusionRecipeBuilder(RecipeBuilder<FusionRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public FusionRecipeBuilder copy() {
        return new FusionRecipeBuilder(this);
    }

    @Override
    public boolean applyProperty(String key, Object value) {
        if (key.equals("eu_to_start")) {
            this.EUToStart(((Number)value).intValue());
            return true;
        }
        return false;
    }

    public FusionRecipeBuilder EUToStart(int EUToStart) {
        if (EUToStart <= 0) {
            GTLog.logger.error("EU to start cannot be less than or equal to 0", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.EUToStart = EUToStart;
        return this;
    }

    @Override
    public ValidationResult<Recipe> build() {
        return ValidationResult.newResult(this.finalizeAndValidate(), new Recipe(this.inputs, (List<ItemStack>)this.outputs, (TObjectIntMap<ItemStack>)this.chancedOutputs, this.fluidInputs, this.fluidOutputs, (Map<String, Object>)ImmutableMap.of((Object)"eu_to_start", (Object)this.EUToStart), this.duration, this.EUt, this.hidden, this.needsEmptyOutput));
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("EUToStart", this.EUToStart).toString();
    }
}

