/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.type;

import com.google.common.collect.ImmutableList;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.enchantments.IEnchantment;
import gregtech.api.enchants.EnchantmentData;
import gregtech.api.unification.Element;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.gregtech.material.SolidMaterial")
@ZenRegister
public abstract class SolidMaterial
extends DustMaterial {
    @ZenProperty
    public final float toolSpeed;
    public final float toolAttackDamage;
    @ZenProperty
    public final int toolDurability;
    @ZenProperty
    public final List<EnchantmentData> toolEnchantments = new ArrayList<EnchantmentData>();
    @ZenProperty
    public DustMaterial macerateInto = this;

    public SolidMaterial(int metaItemSubId, String name, int materialRGB, MaterialIconSet materialIconSet, int harvestLevel, ImmutableList<MaterialStack> materialComponents, long materialGenerationFlags, Element element, float toolSpeed, float toolAttackDamage, int toolDurability) {
        super(metaItemSubId, name, materialRGB, materialIconSet, harvestLevel, materialComponents, materialGenerationFlags, element);
        this.toolSpeed = toolSpeed;
        this.toolAttackDamage = toolAttackDamage;
        this.toolDurability = toolDurability;
    }

    @Override
    protected long verifyMaterialBits(long generationBits) {
        if ((generationBits & MatFlags.GENERATE_GEAR) > 0L) {
            generationBits |= DustMaterial.MatFlags.GENERATE_PLATE;
            generationBits |= MatFlags.GENERATE_ROD;
        }
        if ((generationBits & MatFlags.GENERATE_LONG_ROD) > 0L) {
            generationBits |= MatFlags.GENERATE_ROD;
        }
        return super.verifyMaterialBits(generationBits);
    }

    public void setMaceratingInto(DustMaterial macerateInto) {
        this.macerateInto = macerateInto;
    }

    public void addEnchantmentForTools(Enchantment enchantment, int level) {
        this.toolEnchantments.add(new EnchantmentData(enchantment, level));
    }

    @ZenMethod(value="addToolEnchantment")
    @Optional.Method(modid="crafttweaker")
    public void ctAddEnchantmentForTools(IEnchantment enchantment) {
        Enchantment enchantmentType = (Enchantment)enchantment.getDefinition().getInternal();
        this.toolEnchantments.add(new EnchantmentData(enchantmentType, enchantment.getLevel()));
    }

    public static final class MatFlags {
        public static final long GENERATE_ROD = GTUtility.createFlag(20);
        public static final long GENERATE_GEAR = GTUtility.createFlag(21);
        public static final long GENERATE_LONG_ROD = GTUtility.createFlag(22);
        public static final long MORTAR_GRINDABLE = GTUtility.createFlag(24);
        public static final long GENERATE_FRAME = GTUtility.createFlag(45);

        static {
            Material.MatFlags.registerMaterialFlagsHolder(MatFlags.class, SolidMaterial.class);
        }
    }
}

