/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class WatchedFluidTank
extends FluidTank {
    private FluidStack oldFluidStack;

    public WatchedFluidTank(int capacity) {
        super(capacity);
        this.oldFluidStack = null;
    }

    public WatchedFluidTank(@Nullable FluidStack fluidStack, int capacity) {
        super(fluidStack, capacity);
        this.oldFluidStack = fluidStack == null ? null : fluidStack.copy();
    }

    public final void onContentsChanged() {
        FluidStack newFluidStack = this.getFluid();
        if (WatchedFluidTank.hasFluidChanged(newFluidStack, this.oldFluidStack)) {
            this.onFluidChanged(newFluidStack, this.oldFluidStack);
            if (this.oldFluidStack != null && this.oldFluidStack.isFluidEqual(newFluidStack)) {
                this.oldFluidStack.amount = newFluidStack.amount;
            } else {
                this.oldFluidStack = newFluidStack == null ? null : newFluidStack.copy();
            }
        }
    }

    private static boolean hasFluidChanged(FluidStack newFluid, FluidStack oldFluid) {
        if (newFluid == null && oldFluid == null) {
            return false;
        }
        if (newFluid == null || oldFluid == null) {
            return true;
        }
        return !newFluid.isFluidEqual(oldFluid) || newFluid.amount != oldFluid.amount;
    }

    protected abstract void onFluidChanged(FluidStack var1, FluidStack var2);
}

