/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.IWeighted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;

public class WeightedList<T extends IWeighted> {
    protected ArrayList<T> list = new ArrayList();
    private int totalWeight = 0;

    public WeightedList() {
    }

    public WeightedList(Collection<? extends T> objects) {
        objects.forEach(this::add);
    }

    public WeightedList<T> add(T object) {
        this.list.add(object);
        this.totalWeight += object.getWeight();
        return this;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List<T> getAllObjects() {
        return (List)this.list.clone();
    }

    public T getRandomObject(Random random) {
        if (this.totalWeight == 0) {
            return null;
        }
        if (this.list.size() == 1) {
            return (T)((IWeighted)this.list.get(0));
        }
        int n = random.nextInt(this.totalWeight);
        for (IWeighted object : this.list) {
            if ((n -= object.getWeight()) >= 0) continue;
            return (T)object;
        }
        return null;
    }

    public static class WeightedWrapperList<T>
    extends WeightedList<IWeighted.Wrapper<T>> {
        public WeightedWrapperList() {
        }

        public WeightedWrapperList(Map<? extends T, Integer> map) {
            map.forEach(this::add);
        }

        public WeightedWrapperList<T> add(T object, int weight) {
            super.add(new IWeighted.Wrapper<T>(object, weight));
            return this;
        }

        public List<T> fetchAllObjects() {
            return this.list.stream().map(IWeighted.Wrapper::getObject).collect(Collectors.toList());
        }

        public T fetchRandomObject(Random random) {
            return ((IWeighted.Wrapper)this.getRandomObject(random)).getObject();
        }

        public static <T> WeightedWrapperList<T> mergeWeightedList(WeightedWrapperList<WeightedWrapperList<T>> list) {
            WeightedWrapperList l = new WeightedWrapperList();
            list.list.forEach(c -> ((WeightedWrapperList)c.getObject()).list.forEach(o -> l.add(o.getObject(), o.getWeight() * c.getWeight())));
            return l;
        }
    }
}

