/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.common.items.MetaItems;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="gregtech")
public class FieldProjectorEventHandler {
    private static final long EU_PER_PROJECTILE_DEFLECT = 1024L;

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Pair<Boolean, Entity> projectileData;
        Entity hitEntity = event.getRayTraceResult().field_72308_g;
        if (hitEntity instanceof EntityLivingBase && FieldProjectorEventHandler.canReflectProjectile((EntityLivingBase)hitEntity, true) && ((Boolean)(projectileData = FieldProjectorEventHandler.isHostileProjectile(event.getEntity(), hitEntity)).getLeft()).booleanValue()) {
            Vec3d resultHitPosition;
            Entity shooterEntity = (Entity)projectileData.getRight();
            if (shooterEntity != null) {
                double posY = shooterEntity.field_70163_u + (double)shooterEntity.field_70131_O / 3.0;
                resultHitPosition = new Vec3d(shooterEntity.field_70165_t, posY, shooterEntity.field_70161_v);
            } else {
                Vec3d lookVector = hitEntity.func_70040_Z();
                resultHitPosition = hitEntity.func_174791_d().func_178787_e(lookVector.func_186678_a(5.0));
            }
            if (FieldProjectorEventHandler.canReflectProjectile((EntityLivingBase)hitEntity, false)) {
                FieldProjectorEventHandler.redirectProjectile(event.getEntity(), resultHitPosition);
                if (!hitEntity.field_70170_p.field_72995_K) {
                    Vec3d arrowPos = event.getEntity().func_174791_d();
                    ((WorldServer)hitEntity.field_70170_p).func_180505_a(EnumParticleTypes.SPELL_WITCH, false, arrowPos.field_72450_a, arrowPos.field_72448_b, arrowPos.field_72449_c, 4, 0.0, 0.0, 0.0, 0.1, new int[0]);
                }
                event.setCanceled(true);
            }
        }
    }

    private static boolean canReflectProjectile(EntityLivingBase entity, boolean simulate) {
        if (entity instanceof EntityPlayer) {
            InventoryPlayer inventory = ((EntityPlayer)entity).field_71071_by;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemStack = inventory.func_70301_a(i);
                if (!FieldProjectorEventHandler.tryDrainProjector(itemStack, simulate)) continue;
                return true;
            }
        } else {
            for (EntityEquipmentSlot equipmentSlot : EntityEquipmentSlot.values()) {
                ItemStack itemStack = entity.func_184582_a(equipmentSlot);
                if (!FieldProjectorEventHandler.tryDrainProjector(itemStack, simulate)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryDrainProjector(ItemStack itemStack, boolean simulate) {
        if (!MetaItems.ENERGY_FIELD_PROJECTOR.isItemEqual(itemStack)) {
            return false;
        }
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        return electricItem != null && electricItem.discharge(1024L, electricItem.getTier(), true, false, simulate) >= 1024L;
    }

    private static Pair<Boolean, Entity> isHostileProjectile(Entity entity, Entity owner) {
        if (entity instanceof EntityFireball) {
            EntityLivingBase shooter = ((EntityFireball)entity).field_70235_a;
            return Pair.of((Object)(!owner.func_70028_i((Entity)shooter) ? 1 : 0), (Object)shooter);
        }
        if (entity instanceof EntityArrow) {
            Entity shooter = ((EntityArrow)entity).field_70250_c;
            return Pair.of((Object)(!owner.func_70028_i(shooter) ? 1 : 0), (Object)shooter);
        }
        if (entity instanceof EntityPotion) {
            EntityLivingBase shooter = ((EntityPotion)entity).func_85052_h();
            ItemStack potionStack = ((EntityPotion)entity).func_184543_l();
            List effectList = PotionUtils.func_185189_a((ItemStack)potionStack);
            boolean hasBadEffects = effectList.stream().anyMatch(it -> it.func_188419_a().func_76398_f());
            return Pair.of((Object)(!owner.func_70028_i((Entity)shooter) && hasBadEffects ? 1 : 0), (Object)shooter);
        }
        if (entity instanceof EntityThrowable) {
            EntityLivingBase shooter = ((EntityThrowable)entity).func_85052_h();
            return Pair.of((Object)(!owner.func_70028_i((Entity)shooter) ? 1 : 0), (Object)shooter);
        }
        if (entity instanceof IThrowableEntity) {
            Entity shooter = ((IThrowableEntity)entity).getThrower();
            return Pair.of((Object)(!owner.func_70028_i(shooter) ? 1 : 0), (Object)shooter);
        }
        if (entity instanceof IProjectile) {
            return Pair.of((Object)true, null);
        }
        return Pair.of((Object)false, null);
    }

    private static void redirectProjectile(Entity entity, Vec3d targetPosition) {
        if (entity instanceof EntityFireball) {
            Vec3d directionVector = targetPosition.func_178788_d(entity.func_174791_d()).func_72432_b();
            float motionLength = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y));
            entity.field_70159_w = directionVector.field_72450_a * (double)motionLength;
            entity.field_70181_x = directionVector.field_72448_b * (double)motionLength;
            entity.field_70179_y = directionVector.field_72449_c * (double)motionLength;
            ((EntityFireball)entity).field_70232_b = directionVector.field_72450_a * 0.1;
            ((EntityFireball)entity).field_70233_c = directionVector.field_72448_b * 0.1;
            ((EntityFireball)entity).field_70230_d = directionVector.field_72449_c * 0.1;
        } else if (entity instanceof IProjectile) {
            Vec3d distanceVector = targetPosition.func_178788_d(entity.func_174791_d());
            float motionLength = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y));
            double verticalAccl = MathHelper.func_76133_a((double)(distanceVector.field_72450_a * distanceVector.field_72450_a + distanceVector.field_72449_c * distanceVector.field_72449_c));
            ((IProjectile)entity).func_70186_c(distanceVector.field_72450_a, distanceVector.field_72448_b + verticalAccl * 0.2, distanceVector.field_72449_c, motionLength, 0.0f);
        }
        entity.field_70133_I = true;
    }
}

