/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import gregtech.api.items.ToolDictNames;
import gregtech.api.items.metaitem.ElectricStats;
import gregtech.api.items.toolitem.ScrewdriverItemStat;
import gregtech.api.items.toolitem.SoftMalletItemStat;
import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.api.items.toolitem.WrenchItemStat;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.items.MetaItems;
import gregtech.common.tools.ToolAxe;
import gregtech.common.tools.ToolBranchCutter;
import gregtech.common.tools.ToolButcheryKnife;
import gregtech.common.tools.ToolBuzzSaw;
import gregtech.common.tools.ToolChainsawHV;
import gregtech.common.tools.ToolChainsawLV;
import gregtech.common.tools.ToolChainsawMV;
import gregtech.common.tools.ToolCrowbar;
import gregtech.common.tools.ToolDrillHV;
import gregtech.common.tools.ToolDrillLV;
import gregtech.common.tools.ToolDrillMV;
import gregtech.common.tools.ToolFile;
import gregtech.common.tools.ToolHardHammer;
import gregtech.common.tools.ToolHoe;
import gregtech.common.tools.ToolJackHammer;
import gregtech.common.tools.ToolKnife;
import gregtech.common.tools.ToolMagnifyingGlass;
import gregtech.common.tools.ToolMortar;
import gregtech.common.tools.ToolPickaxe;
import gregtech.common.tools.ToolPlunger;
import gregtech.common.tools.ToolSaw;
import gregtech.common.tools.ToolScoop;
import gregtech.common.tools.ToolScrewdriver;
import gregtech.common.tools.ToolScrewdriverLV;
import gregtech.common.tools.ToolSense;
import gregtech.common.tools.ToolShovel;
import gregtech.common.tools.ToolSoftHammer;
import gregtech.common.tools.ToolSword;
import gregtech.common.tools.ToolUniversalSpade;
import gregtech.common.tools.ToolWireCutter;
import gregtech.common.tools.ToolWrench;
import gregtech.common.tools.ToolWrenchHV;
import gregtech.common.tools.ToolWrenchLV;
import gregtech.common.tools.ToolWrenchMV;
import java.util.function.Function;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class MetaTool
extends ToolMetaItem<ToolMetaItem.MetaToolValueItem> {
    @Override
    public void registerSubItems() {
        MetaItems.SWORD = ((ToolMetaItem.MetaToolValueItem)this.addItem(0, "tool.sword")).setToolStats(new ToolSword()).setFullRepairCost(2.0).addOreDict(ToolDictNames.craftingToolSword);
        MetaItems.PICKAXE = ((ToolMetaItem.MetaToolValueItem)this.addItem(1, "tool.pickaxe")).setToolStats(new ToolPickaxe()).setFullRepairCost(3.0).addOreDict(ToolDictNames.craftingToolPickaxe);
        MetaItems.SHOVEL = ((ToolMetaItem.MetaToolValueItem)this.addItem(2, "tool.shovel")).setToolStats(new ToolShovel()).setFullRepairCost(1.0).addOreDict(ToolDictNames.craftingToolShovel);
        MetaItems.AXE = ((ToolMetaItem.MetaToolValueItem)this.addItem(3, "tool.axe")).setToolStats(new ToolAxe()).setFullRepairCost(3.0).addOreDict(ToolDictNames.craftingToolAxe);
        MetaItems.HOE = ((ToolMetaItem.MetaToolValueItem)this.addItem(4, "tool.hoe")).setToolStats(new ToolHoe()).setFullRepairCost(2.0).addOreDict(ToolDictNames.craftingToolHoe);
        MetaItems.SAW = ((ToolMetaItem.MetaToolValueItem)this.addItem(5, "tool.saw")).setToolStats(new ToolSaw()).setFullRepairCost(2.0).addOreDict(ToolDictNames.craftingToolSaw);
        MetaItems.HARD_HAMMER = ((ToolMetaItem.MetaToolValueItem)this.addItem(6, "tool.hard_hammer")).setToolStats(new ToolHardHammer()).setFullRepairCost(6.0).addOreDict(ToolDictNames.craftingToolHardHammer);
        MetaItems.SOFT_HAMMER = ((ToolMetaItem.MetaToolValueItem)this.addItem(7, "tool.soft_hammer")).setToolStats(new ToolSoftHammer()).setFullRepairCost(6.0).addOreDict(ToolDictNames.craftingToolSoftHammer).addStats(new SoftMalletItemStat());
        MetaItems.WRENCH = ((ToolMetaItem.MetaToolValueItem)this.addItem(8, "tool.wrench")).setToolStats(new ToolWrench()).setFullRepairCost(6.0).addOreDict(ToolDictNames.craftingToolWrench).addStats(new WrenchItemStat());
        MetaItems.FILE = ((ToolMetaItem.MetaToolValueItem)this.addItem(9, "tool.file")).setToolStats(new ToolFile()).setFullRepairCost(2.0).addOreDict(ToolDictNames.craftingToolFile);
        MetaItems.CROWBAR = ((ToolMetaItem.MetaToolValueItem)this.addItem(10, "tool.crowbar")).setToolStats(new ToolCrowbar()).setFullRepairCost(1.5).addOreDict(ToolDictNames.craftingToolCrowbar);
        MetaItems.SCREWDRIVER = ((ToolMetaItem.MetaToolValueItem)this.addItem(11, "tool.screwdriver")).setToolStats(new ToolScrewdriver()).setFullRepairCost(1.0).addOreDict(ToolDictNames.craftingToolScrewdriver).addStats(new ScrewdriverItemStat());
        MetaItems.MORTAR = ((ToolMetaItem.MetaToolValueItem)this.addItem(12, "tool.mortar")).setToolStats(new ToolMortar()).addOreDict(ToolDictNames.craftingToolMortar);
        MetaItems.WIRE_CUTTER = ((ToolMetaItem.MetaToolValueItem)this.addItem(13, "tool.wire_cutter")).setToolStats(new ToolWireCutter()).setFullRepairCost(4.125).addOreDict(ToolDictNames.craftingToolWireCutter);
        MetaItems.SCOOP = ((ToolMetaItem.MetaToolValueItem)this.addItem(14, "tool.scoop")).setToolStats(new ToolScoop()).setFullRepairCost(3.0).addOreDict(ToolDictNames.craftingToolScoop);
        MetaItems.BRANCH_CUTTER = ((ToolMetaItem.MetaToolValueItem)this.addItem(15, "tool.branch_cutter")).setToolStats(new ToolBranchCutter()).setFullRepairCost(5.125).addOreDict(ToolDictNames.craftingToolBranchCutter);
        MetaItems.UNIVERSAL_SPADE = ((ToolMetaItem.MetaToolValueItem)this.addItem(16, "tool.universal_spade")).setToolStats(new ToolUniversalSpade()).setFullRepairCost(5.0).addOreDict(ToolDictNames.craftingToolBlade, ToolDictNames.craftingToolShovel, ToolDictNames.craftingToolCrowbar, ToolDictNames.craftingToolSaw);
        MetaItems.KNIFE = ((ToolMetaItem.MetaToolValueItem)this.addItem(17, "tool.knife")).setToolStats(new ToolKnife()).setFullRepairCost(1.5).addOreDict(ToolDictNames.craftingToolBlade, ToolDictNames.craftingToolKnife);
        MetaItems.BUTCHERY_KNIFE = ((ToolMetaItem.MetaToolValueItem)this.addItem(18, "tool.butchery_knife")).setToolStats(new ToolButcheryKnife()).setFullRepairCost(4.5).addOreDict(ToolDictNames.craftingToolBlade);
        MetaItems.SENSE = ((ToolMetaItem.MetaToolValueItem)this.addItem(19, "tool.sense")).setToolStats(new ToolSense()).setFullRepairCost(3.0).addOreDict(ToolDictNames.craftingToolBlade);
        MetaItems.DRILL_LV = ((ToolMetaItem.MetaToolValueItem)this.addItem(23, "tool.drill.lv")).setToolStats(new ToolDrillLV()).setFullRepairCost(4.0).addOreDict(ToolDictNames.craftingToolMiningDrill).addStats(ElectricStats.createElectricItem(100000L, 1L));
        MetaItems.DRILL_MV = ((ToolMetaItem.MetaToolValueItem)this.addItem(24, "tool.drill.mv")).setToolStats(new ToolDrillMV()).setFullRepairCost(4.0).addOreDict(ToolDictNames.craftingToolMiningDrill).addStats(ElectricStats.createElectricItem(400000L, 2L));
        MetaItems.DRILL_HV = ((ToolMetaItem.MetaToolValueItem)this.addItem(25, "tool.drill.hv")).setToolStats(new ToolDrillHV()).setFullRepairCost(4.0).addOreDict(ToolDictNames.craftingToolMiningDrill).addStats(ElectricStats.createElectricItem(1600000L, 3L));
        MetaItems.CHAINSAW_LV = ((ToolMetaItem.MetaToolValueItem)this.addItem(26, "tool.chainsaw.lv")).setToolStats(new ToolChainsawLV()).setFullRepairCost(4.0).addOreDict(ToolDictNames.craftingToolSaw).addStats(ElectricStats.createElectricItem(100000L, 1L));
        MetaItems.CHAINSAW_MV = ((ToolMetaItem.MetaToolValueItem)this.addItem(27, "tool.chainsaw.mv")).setToolStats(new ToolChainsawMV()).setFullRepairCost(4.0).addOreDict(ToolDictNames.craftingToolSaw).addStats(ElectricStats.createElectricItem(400000L, 2L));
        MetaItems.CHAINSAW_HV = ((ToolMetaItem.MetaToolValueItem)this.addItem(28, "tool.chainsaw.hv")).setToolStats(new ToolChainsawHV()).setFullRepairCost(4.0).addOreDict(ToolDictNames.craftingToolSaw).addStats(ElectricStats.createElectricItem(1600000L, 3L));
        MetaItems.WRENCH_LV = ((ToolMetaItem.MetaToolValueItem)this.addItem(29, "tool.wrench.lv")).setToolStats(new ToolWrenchLV()).setFullRepairCost(4.0).addOreDict(ToolDictNames.craftingToolWrench).addStats(new WrenchItemStat()).addStats(ElectricStats.createElectricItem(100000L, 1L));
        MetaItems.WRENCH_MV = ((ToolMetaItem.MetaToolValueItem)this.addItem(30, "tool.wrench.mv")).setToolStats(new ToolWrenchMV()).setFullRepairCost(4.0).addOreDict(ToolDictNames.craftingToolWrench).addStats(new WrenchItemStat()).addStats(ElectricStats.createElectricItem(400000L, 2L));
        MetaItems.WRENCH_HV = ((ToolMetaItem.MetaToolValueItem)this.addItem(31, "tool.wrench.hv")).setToolStats(new ToolWrenchHV()).setFullRepairCost(4.0).addOreDict(ToolDictNames.craftingToolWrench).addStats(new WrenchItemStat()).addStats(ElectricStats.createElectricItem(1600000L, 3L));
        MetaItems.SCREWDRIVER_LV = ((ToolMetaItem.MetaToolValueItem)this.addItem(34, "tool.screwdriver.lv")).setToolStats(new ToolScrewdriverLV()).setFullRepairCost(1.0).addOreDict(ToolDictNames.craftingToolScrewdriver).addStats(new ScrewdriverItemStat()).addStats(ElectricStats.createElectricItem(100000L, 1L));
        MetaItems.JACKHAMMER = ((ToolMetaItem.MetaToolValueItem)this.addItem(32, "tool.jackhammer")).setToolStats(new ToolJackHammer()).setFullRepairCost(5.0).addOreDict(ToolDictNames.craftingToolJackHammer).addStats(ElectricStats.createElectricItem(1600000L, 3L));
        MetaItems.BUZZSAW = ((ToolMetaItem.MetaToolValueItem)this.addItem(33, "tool.buzzsaw")).setToolStats(new ToolBuzzSaw()).setFullRepairCost(4.0).addOreDict(ToolDictNames.craftingToolSaw).addStats(ElectricStats.createElectricItem(100000L, 1L));
        MetaItems.MAGNIFYING_GLASS = ((ToolMetaItem.MetaToolValueItem)this.addItem(36, "tool.magnifying_glass")).setToolStats(new ToolMagnifyingGlass()).addOreDict(ToolDictNames.craftingToolMagnifyingGlass);
        MetaItems.PLUNGER = ((ToolMetaItem.MetaToolValueItem)this.addItem(37, "tool.plunger")).setToolStats(new ToolPlunger()).addOreDict(ToolDictNames.craftingToolPlunger);
    }

    public void registerRecipes() {
        IngotMaterial[] mortarMaterials;
        for (IngotMaterial material : mortarMaterials = new IngotMaterial[]{Materials.Bronze, Materials.Iron, Materials.Steel, Materials.DamascusSteel, Materials.WroughtIron, Materials.RedSteel, Materials.BlackSteel, Materials.BlueSteel}) {
            ModHandler.addShapedRecipe("mortar_" + material.toString(), MetaItems.MORTAR.getStackForm(material), new Object[]{" I ", "SIS", "SSS", Character.valueOf('I'), new UnificationEntry(OrePrefix.ingot, material), Character.valueOf('S'), OrePrefix.stone});
        }
        SolidMaterial[] softHammerMaterials = new SolidMaterial[]{Materials.Wood, Materials.Rubber, Materials.Plastic, Materials.Polytetrafluoroethylene};
        for (int i = 0; i < softHammerMaterials.length; ++i) {
            SolidMaterial solidMaterial = softHammerMaterials[i];
            ItemStack itemStack = MetaItems.SOFT_HAMMER.getStackForm();
            MetaItems.SOFT_HAMMER.setToolData(itemStack, solidMaterial, 128 * (1 << i), 1, 4.0f, 1.0f);
            ModHandler.addShapedRecipe(String.format("soft_hammer_%s", solidMaterial.toString()), itemStack, "XX ", "XXS", "XX ", Character.valueOf('X'), new UnificationEntry(OrePrefix.ingot, solidMaterial), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        }
        Function<ToolMetaItem.MetaToolValueItem, ItemStack> woodenToolDataApplier = item -> item.setToolData(item.getStackForm(), Materials.Wood, 55, 1, 4.0f, 1.0f);
        ModHandler.addShapedRecipe("soft_hammer_wooden", woodenToolDataApplier.apply(MetaItems.SOFT_HAMMER), "XX ", "XXS", "XX ", Character.valueOf('X'), new UnificationEntry(OrePrefix.plank, Materials.Wood), Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood));
        this.registerFlintToolRecipes();
    }

    private void registerFlintToolRecipes() {
        Function<ToolMetaItem.MetaToolValueItem, ItemStack> toolDataApplier = item -> {
            ItemStack itemStack = item.setToolData(item.getStackForm(), Materials.Flint, 80, 1, 6.0f, 2.0f);
            if (itemStack.func_77973_b().canApplyAtEnchantingTable(itemStack, Enchantments.field_77334_n)) {
                itemStack.func_77966_a(Enchantments.field_77334_n, 2);
            }
            return itemStack;
        };
        ModHandler.addShapedRecipe("mortar_flint", toolDataApplier.apply(MetaItems.MORTAR), new Object[]{" I ", "SIS", "SSS", Character.valueOf('I'), new ItemStack(Items.field_151145_ak, 1), Character.valueOf('S'), OrePrefix.stone});
        ModHandler.addShapedRecipe("sword_flint", toolDataApplier.apply(MetaItems.SWORD), "F", "F", "S", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('F'), new ItemStack(Items.field_151145_ak, 1));
        ModHandler.addShapedRecipe("pickaxe_flint", toolDataApplier.apply(MetaItems.PICKAXE), "FFF", " S ", " S ", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('F'), new ItemStack(Items.field_151145_ak, 1));
        ModHandler.addShapedRecipe("shovel_flint", toolDataApplier.apply(MetaItems.SHOVEL), "F", "S", "S", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('F'), new ItemStack(Items.field_151145_ak, 1));
        ModHandler.addMirroredShapedRecipe("axe_flint", toolDataApplier.apply(MetaItems.AXE), "FF", "FS", " S", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('F'), new ItemStack(Items.field_151145_ak, 1));
        ModHandler.addMirroredShapedRecipe("hoe_flint", toolDataApplier.apply(MetaItems.HOE), "FF", " S", " S", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('F'), new ItemStack(Items.field_151145_ak, 1));
        ModHandler.addShapedRecipe("knife_flint", toolDataApplier.apply(MetaItems.KNIFE), "F", "S", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, Materials.Wood), Character.valueOf('F'), new ItemStack(Items.field_151145_ak, 1));
    }
}

