/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.unification.material.type.Material;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.surfacerock.BlockSurfaceRock;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class MagnifyingGlassBehaviour
implements IItemBehaviour {
    private final int cost;

    public MagnifyingGlassBehaviour(int cost) {
        this.cost = cost;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        lines.add(I18n.func_135052_a((String)"behavior.magnifying_glass.description", (Object[])new Object[0]));
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IBlockState blockState = world.func_180495_p(pos);
        ItemStack itemStack = player.func_184586_b(hand);
        if (blockState.func_177230_c() instanceof BlockSurfaceRock && GTUtility.doDamageItem(itemStack, this.cost, true)) {
            GTUtility.doDamageItem(itemStack, this.cost, false);
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            BlockSurfaceRock block = (BlockSurfaceRock)blockState.func_177230_c();
            Material rockMaterial = (Material)blockState.func_177229_b((IProperty)block.materialProperty);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("behavior.magnifying_glass.inspect.primary", new Object[]{MagnifyingGlassBehaviour.getNameForMaterial(rockMaterial)}));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private static ITextComponent getNameForMaterial(Material material) {
        return new TextComponentTranslation(material.getUnlocalizedName(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD));
    }
}

