/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IEntityButterfly;
import gregtech.api.GTValues;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.util.GTUtility;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

public class ScoopBehaviour
implements IItemBehaviour {
    private final int cost;

    public ScoopBehaviour(int cost) {
        this.cost = cost;
    }

    @Override
    public boolean onLeftClickEntity(ItemStack itemStack, EntityPlayer player, Entity entity) {
        return GTValues.isModLoaded("forestry") && this.processButterflyCatch(itemStack, player, entity);
    }

    @Optional.Method(modid="forestry")
    private boolean processButterflyCatch(ItemStack itemStack, EntityPlayer player, Entity entity) {
        if (entity instanceof IEntityButterfly) {
            if (player.field_70170_p.field_72995_K) {
                return true;
            }
            if (player.field_71075_bZ.field_75098_d || GTUtility.doDamageItem(itemStack, this.cost, false)) {
                IEntityButterfly butterfly = (IEntityButterfly)entity;
                IAlleleButterflySpecies species = butterfly.getButterfly().getGenome().getPrimary();
                species.getRoot().getBreedingTracker(entity.field_70170_p, player.func_146103_bH()).registerCatch(butterfly.getButterfly());
                player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, species.getRoot().getMemberStack((IIndividual)butterfly.getButterfly().copy(), (ISpeciesType)EnumFlutterType.BUTTERFLY)));
                entity.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        lines.add(I18n.func_135052_a((String)"behaviour.scoop", (Object[])new Object[0]));
    }
}

