/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.generator;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.FuelRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.BlockWorldState;
import gregtech.api.multiblock.FactoryBlockPattern;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.render.ICubeRenderer;
import gregtech.api.render.Textures;
import gregtech.api.unification.material.Materials;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.electric.generator.DieselEngineWorkableHandler;
import gregtech.common.metatileentities.multi.electric.generator.FueledMultiblockController;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;

public class MetaTileEntityDieselEngine
extends FueledMultiblockController {
    public MetaTileEntityDieselEngine(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.DIESEL_GENERATOR_FUELS, GTValues.V[4]);
    }

    @Override
    protected FuelRecipeLogic createWorkable(long maxVoltage) {
        return new DieselEngineWorkableHandler(this, this.recipeMap, () -> this.energyContainer, () -> this.importFluidHandler, maxVoltage);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityDieselEngine(this.metaTileEntityId);
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        if (this.isStructureFormed()) {
            FluidStack lubricantStack = this.importFluidHandler.drain(Materials.Lubricant.getFluid(Integer.MAX_VALUE), false);
            FluidStack oxygenStack = this.importFluidHandler.drain(Materials.Oxygen.getFluid(Integer.MAX_VALUE), false);
            FluidStack fuelStack = ((DieselEngineWorkableHandler)this.workableHandler).getFuelStack();
            int lubricantAmount = lubricantStack == null ? 0 : lubricantStack.amount;
            int oxygenAmount = oxygenStack == null ? 0 : oxygenStack.amount;
            int fuelAmount = fuelStack == null ? 0 : fuelStack.amount;
            TextComponentTranslation fuelName = new TextComponentTranslation(fuelAmount == 0 ? "gregtech.fluid.empty" : fuelStack.getUnlocalizedName(), new Object[0]);
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.diesel_engine.lubricant_amount", new Object[]{lubricantAmount}));
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.diesel_engine.fuel_amount", new Object[]{fuelAmount, fuelName}));
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.diesel_engine.oxygen_amount", new Object[]{oxygenAmount}));
            textList.add((ITextComponent)new TextComponentTranslation(oxygenAmount >= 2 ? "gregtech.multiblock.diesel_engine.oxygen_boosted" : "gregtech.multiblock.diesel_engine.supply_oxygen_to_boost", new Object[0]));
        }
        super.addDisplayText(textList);
    }

    protected Predicate<BlockWorldState> intakeCasingPredicate() {
        IBlockState blockState = MetaBlocks.MUTLIBLOCK_CASING.getState(BlockMultiblockCasing.MultiblockCasingType.ENGINE_INTAKE_CASING);
        return blockWorldState -> {
            if (blockWorldState.getBlockState() != blockState) {
                return false;
            }
            IBlockState offsetState = blockWorldState.getOffsetState(this.getFrontFacing());
            return offsetState.func_177230_c().isAir(offsetState, (IBlockAccess)blockWorldState.getWorld(), blockWorldState.getPos());
        };
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "XDX", "XXX").aisle("XHX", "HGH", "XHX").aisle("XHX", "HGH", "XHX").aisle("AAA", "AYA", "AAA").where('X', MetaTileEntityDieselEngine.statePredicate(this.getCasingState())).where('G', MetaTileEntityDieselEngine.statePredicate(MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.TITANIUM_GEARBOX))).where('H', MetaTileEntityDieselEngine.statePredicate(this.getCasingState()).or(MetaTileEntityDieselEngine.abilityPartPredicate(MultiblockAbility.IMPORT_FLUIDS))).where('D', MetaTileEntityDieselEngine.abilityPartPredicate(MultiblockAbility.OUTPUT_ENERGY)).where('A', this.intakeCasingPredicate()).where('Y', this.selfPredicate()).build();
    }

    public IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE);
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.STABLE_TITANIUM_CASING;
    }
}

