/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiTexture
extends MGuiElementBase<GuiTexture> {
    public int texU;
    public int texV;
    public int textSheetSizeX = 256;
    public int textSheetSizeY = 256;
    private int texUSize = 0;
    private int texVSize = 0;
    private boolean texSizeOverride = false;
    private Supplier<Integer> texXGetter = null;
    private Supplier<Integer> texYGetter = null;
    public ResourceLocation texture;
    public Supplier<ResourceLocation> textureSupplier;

    public GuiTexture(int xPos, int yPos, int textureX, int textureY, int xSize, int ySize, ResourceLocation texture) {
        super(xPos, yPos, xSize, ySize);
        this.texU = textureX;
        this.texV = textureY;
        this.texture = texture;
    }

    public GuiTexture(int textureX, int textureY, int xSize, int ySize, ResourceLocation texture) {
        super(0, 0, xSize, ySize);
        this.texU = textureX;
        this.texV = textureY;
        this.texture = texture;
    }

    public GuiTexture(int xSize, int ySize, ResourceLocation texture) {
        super(0, 0, xSize, ySize);
        this.texture = texture;
    }

    public GuiTexture(Supplier<ResourceLocation> textureSupplier) {
        super(0, 0);
        this.textureSupplier = textureSupplier;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture(this.getTexture());
        if (this.preDrawCallback == null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.texSizeOverride) {
            this.drawScaledCustomSizeModalRect(this.xPos(), this.yPos(), this.getTexU(), this.getTexV(), this.texUSize, this.texVSize, this.xSize(), this.ySize(), this.textSheetSizeX, this.textSheetSizeY);
        } else {
            this.drawModalRectWithCustomSizedTexture(this.xPos(), this.yPos(), this.getTexU(), this.getTexV(), this.xSize(), this.ySize(), this.textSheetSizeX, this.textSheetSizeY);
        }
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    public GuiTexture setTexturePos(int textureX, int textureY) {
        this.texU = textureX;
        this.texV = textureY;
        return this;
    }

    public GuiTexture setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public void setTextureSupplier(Supplier<ResourceLocation> textureSupplier) {
        this.textureSupplier = textureSupplier;
    }

    public ResourceLocation getTexture() {
        return this.textureSupplier == null ? this.texture : this.textureSupplier.get();
    }

    public GuiTexture setTexture(String texture) {
        this.texture = ResourceHelperBC.getResourceRAW(texture);
        return this;
    }

    public GuiTexture setTexSizeOverride(int texXOverride, int texYOverride) {
        this.texUSize = texXOverride;
        this.texVSize = texYOverride;
        this.texSizeOverride = true;
        return this;
    }

    public GuiTexture setTexSheetSize(int textureSizeX, int textureSizeY) {
        this.textSheetSizeX = textureSizeX;
        this.textSheetSizeY = textureSizeY;
        return this;
    }

    public GuiTexture setTexSheetSize(int textureSize) {
        return this.setTexSheetSize(textureSize, textureSize);
    }

    public GuiTexture setTexXGetter(Supplier<Integer> texXGetter) {
        this.texXGetter = texXGetter;
        return this;
    }

    public GuiTexture setTexYGetter(Supplier<Integer> texYGetter) {
        this.texYGetter = texYGetter;
        return this;
    }

    public int getTexU() {
        return this.texXGetter == null ? this.texU : this.texXGetter.get();
    }

    public int getTexV() {
        return this.texYGetter == null ? this.texV : this.texYGetter.get();
    }

    public static GuiTexture newBCTexture(int xSize, int ySize) {
        return new GuiTexture(0, 0, xSize, ySize, ResourceHelperBC.getResourceRAW("brandonscore:textures/gui/base_gui.png")){

            @Override
            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                ResourceHelperBC.bindTexture(this.texture);
                this.drawTexturedModalRect(this.xPos(), this.yPos(), 0, 0, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos() + this.xSize() / 2, this.yPos(), 256 - this.xSize() / 2, 0, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos(), this.yPos() + this.ySize() / 2, 0, 256 - this.ySize() / 2, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos() + this.xSize() / 2, this.yPos() + this.ySize() / 2, 256 - this.xSize() / 2, 256 - this.ySize() / 2, this.xSize() / 2, this.ySize() / 2);
                for (MGuiElementBase element : this.childElements) {
                    if (!element.isEnabled()) continue;
                    element.renderElement(minecraft, mouseX, mouseY, partialTicks);
                }
            }
        };
    }

    public static GuiTexture newVanillaGuiTexture(int xSize, int ySize) {
        return new GuiTexture(0, 0, xSize, ySize, ResourceHelperBC.getResourceRAW("brandonscore:textures/gui/base_vanilla_gui.png")){

            @Override
            public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                ResourceHelperBC.bindTexture(this.texture);
                this.drawTexturedModalRect(this.xPos(), this.yPos(), 0, 0, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos() + this.xSize() / 2, this.yPos(), 256 - this.xSize() / 2, 0, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos(), this.yPos() + this.ySize() / 2, 0, 256 - this.ySize() / 2, this.xSize() / 2, this.ySize() / 2);
                this.drawTexturedModalRect(this.xPos() + this.xSize() / 2, this.yPos() + this.ySize() / 2, 256 - this.xSize() / 2, 256 - this.ySize() / 2, this.xSize() / 2, this.ySize() / 2);
                for (MGuiElementBase element : this.childElements) {
                    if (!element.isEnabled()) continue;
                    element.renderElement(minecraft, mouseX, mouseY, partialTicks);
                }
            }
        };
    }
}

