/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.library.tank;

import knightminer.ceramics.library.tank.TileTank;
import knightminer.ceramics.tileentity.TileChannel;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ChannelTank
extends TileTank<TileChannel> {
    private static final String TAG_LOCKED = "locked";
    private int locked;

    public ChannelTank(int capacity, TileChannel parent) {
        super(capacity, parent);
        this.setCanDrain(false);
    }

    public void freeFluid() {
        this.locked = 0;
    }

    public FluidStack getUsableFluid() {
        if (this.fluid == null) {
            return null;
        }
        FluidStack stack = this.fluid.copy();
        stack.amount -= this.locked;
        return stack;
    }

    public int usableFluid() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount - this.locked;
    }

    public int fill(FluidStack resource, boolean doFill) {
        int amount = super.fill(resource, doFill);
        if (doFill) {
            this.locked += amount;
        }
        return amount;
    }

    @Override
    protected void sendUpdate(int amount) {
        FluidStack fluid;
        if (amount != 0 && ((fluid = this.getFluid()) == null || fluid.amount == amount)) {
            super.sendUpdate(amount);
        }
    }

    public FluidTank readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.locked = nbt.func_74762_e(TAG_LOCKED);
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.func_74768_a(TAG_LOCKED, this.locked);
        return nbt;
    }
}

