/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.soundmuffler.gui.data;

import edgarallen.soundmuffler.gui.data.IMufflerAccessor;
import edgarallen.soundmuffler.network.ThePacketeer;
import edgarallen.soundmuffler.network.messages.MessageAddRemoveSound;
import edgarallen.soundmuffler.network.messages.MessageToggleWhiteList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MufflerBauble
implements IMufflerAccessor {
    private EntityPlayer player;

    public MufflerBauble(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public boolean isWhiteList() {
        NBTTagCompound compound;
        ItemStack bauble = this.player.func_184614_ca();
        if (bauble.func_77942_o() && (compound = bauble.func_77978_p()).func_74764_b("whiteList")) {
            return compound.func_74767_n("whiteList");
        }
        return false;
    }

    @Override
    public List<ResourceLocation> getMuffledSounds() {
        NBTTagCompound compound;
        ArrayList<ResourceLocation> sounds = new ArrayList<ResourceLocation>();
        ItemStack bauble = this.player.func_184614_ca();
        if (bauble.func_77942_o() && (compound = bauble.func_77978_p()).func_74764_b("sounds")) {
            NBTTagList list = compound.func_150295_c("sounds", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound c = list.func_150305_b(i);
                String s = c.func_74779_i("sound");
                sounds.add(new ResourceLocation(s));
            }
        }
        Collections.sort(sounds, Comparator.comparing(ResourceLocation::toString));
        return sounds;
    }

    @Override
    public void toggleWhiteList() {
        ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageToggleWhiteList(BlockPos.field_177992_a, MessageToggleWhiteList.Type.Bauble));
    }

    @Override
    public void muffleSound(ResourceLocation sound) {
        ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageAddRemoveSound(BlockPos.field_177992_a, sound, MessageAddRemoveSound.Type.Bauble, MessageAddRemoveSound.Action.Add));
    }

    @Override
    public void unmuffleSound(ResourceLocation sound) {
        ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageAddRemoveSound(BlockPos.field_177992_a, sound, MessageAddRemoveSound.Type.Bauble, MessageAddRemoveSound.Action.Remove));
    }
}

