/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.value;

import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.NullAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IMValueInt
implements GuiAnimatable<IMValueInt> {
    private Storage storage;

    private IMValueInt(Storage initialStorage) {
        this.storage = initialStorage;
    }

    public IMValueInt(int initialValue) {
        this.storage = new Storage.Fixed(initialValue);
    }

    public IMValueInt(IntSupplier initialCallback) {
        this.storage = new Storage.Callback(initialCallback);
    }

    public int get() {
        return this.storage.get();
    }

    public void set(IntSupplier callback) {
        GuiAnimator.getCurrent().add(this);
        if (this.storage instanceof Storage.Callback) {
            ((Storage.Callback)this.storage).callback = callback;
        } else {
            this.storage = new Storage.Callback(callback);
        }
    }

    public void setValue(int value) {
        GuiAnimator.getCurrent().add(this);
        if (this.storage instanceof Storage.Fixed) {
            ((Storage.Fixed)this.storage).value = value;
        } else {
            this.storage = new Storage.Fixed(value);
        }
    }

    public int getValue(Object thisRef, KProperty property) {
        return this.storage.get();
    }

    public void setValue(Object thisRef, KProperty property, int value) {
        this.setValue(value);
    }

    public void invoke(IntSupplier callback) {
        this.set(callback);
    }

    @Nullable
    public IntSupplier getCallback() {
        if (this.storage instanceof Storage.Callback) {
            return ((Storage.Callback)this.storage).callback;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getAnimatableValue() {
        return this.get();
    }

    @Override
    public void setAnimatableValue(@Nullable Object value) {
        this.setValue((Integer)value);
    }

    @Override
    @Nullable
    public Object getAnimatableCallback() {
        return this.getCallback();
    }

    @Override
    public void setAnimatableCallback(@NotNull Object supplier) {
        this.set((IntSupplier)supplier);
    }

    public Animation<IMValueInt> animate(int from, int to, float duration, Easing easing, float delay) {
        AnimationImpl animation = new AnimationImpl(from, to, this);
        animation.setDuration(duration);
        animation.easing = easing;
        animation.setStart(delay);
        Animator.global.add(animation);
        return animation;
    }

    public Animation<IMValueInt> animate(int from, int to, float duration, Easing easing) {
        return this.animate(from, to, duration, easing, 0.0f);
    }

    public Animation<IMValueInt> animate(int from, int to, float duration) {
        return this.animate(from, to, duration, Easing.linear, 0.0f);
    }

    public Animation<IMValueInt> animate(int to, float duration, Easing easing, float delay) {
        AnimationImpl anim2 = (AnimationImpl)this.animate(this.get(), to, duration, easing, delay);
        anim2.implicitStart = true;
        return anim2;
    }

    public Animation<IMValueInt> animate(int to, float duration) {
        return this.animate(to, duration, Easing.linear, 0.0f);
    }

    public Animation<IMValueInt> animate(int to, float duration, Easing easing) {
        return this.animate(to, duration, easing, 0.0f);
    }

    public KeyframeAnimationBuilder animateKeyframes(int initialValue) {
        return this.animateKeyframes(initialValue, 0.0f);
    }

    public KeyframeAnimationBuilder animateKeyframes(int initialValue, float delay) {
        return new KeyframeAnimationBuilder(initialValue, delay, this);
    }

    private static class KeyframeAnimation
    extends Animation<IMValueInt> {
        private List<Keyframe> keyframes;

        KeyframeAnimation(IMValueInt target, List<Keyframe> keyframes) {
            super(target, new NullAnimatable());
            this.keyframes = keyframes;
        }

        @Override
        public void update(float time) {
            float progress2 = this.timeFraction(time);
            Keyframe prev = null;
            Keyframe next = null;
            for (Keyframe it : this.keyframes) {
                if (it.time <= progress2) {
                    prev = it;
                }
                if (!(it.time >= progress2) || next != null) continue;
                next = it;
            }
            if (prev != null && next != null) {
                if (next.time == prev.time) {
                    ((IMValueInt)this.getTarget()).setValue(next.value);
                } else {
                    float partialProgress = next.easing.invoke((progress2 - prev.time) / (next.time - prev.time));
                    ((IMValueInt)this.getTarget()).setValue((int)((float)prev.value + (float)(next.value - prev.value) * partialProgress));
                }
            } else if (next != null) {
                ((IMValueInt)this.getTarget()).setValue(next.value);
            } else if (prev != null) {
                ((IMValueInt)this.getTarget()).setValue(prev.value);
            }
        }
    }

    private static class Keyframe {
        float time;
        int value;
        Easing easing;

        Keyframe(float time, int value, Easing easing) {
            this.time = time;
            this.value = value;
            this.easing = easing;
        }
    }

    public static class KeyframeAnimationBuilder {
        private float delay;
        private IMValueInt target;
        private List<Keyframe> keyframes = new ArrayList<Keyframe>();

        KeyframeAnimationBuilder(int initialValue, float delay, IMValueInt target) {
            this.target = target;
            this.delay = delay;
            this.keyframes.add(new Keyframe(0.0f, initialValue, Easing.linear));
        }

        @NotNull
        public KeyframeAnimationBuilder add(float time, int value) {
            return this.add(time, value, Easing.linear);
        }

        @NotNull
        public KeyframeAnimationBuilder add(float time, int value, @NotNull Easing easing) {
            this.keyframes.add(new Keyframe(time, value, easing));
            return this;
        }

        @NotNull
        public Animation<IMValueInt> finish() {
            if (this.keyframes.isEmpty()) {
                throw new IllegalStateException("Cannot create an empty keyframe animation");
            }
            float duration = 0.0f;
            for (Keyframe keyframe : this.keyframes) {
                duration += keyframe.time;
            }
            float total = 0.0f;
            for (Keyframe it : this.keyframes) {
                it.time = (total += it.time) / duration;
            }
            KeyframeAnimation keyframeAnimation = new KeyframeAnimation(this.target, this.keyframes);
            keyframeAnimation.setDuration(duration);
            keyframeAnimation.setStart(this.delay);
            Animator.global.add(keyframeAnimation);
            return keyframeAnimation;
        }
    }

    private class AnimationImpl
    extends Animation<IMValueInt> {
        int from;
        int to;
        boolean implicitStart;
        Easing easing;

        AnimationImpl(int from, int to, IMValueInt target) {
            super(target, new NullAnimatable());
            this.easing = Easing.linear;
            this.from = from;
            this.to = to;
        }

        @Override
        public void update(float time) {
            if (this.implicitStart) {
                this.from = ((IMValueInt)this.getTarget()).get();
                this.implicitStart = false;
            }
            float progress2 = this.easing.invoke(this.timeFraction(time));
            int newValue = (int)((float)this.from + (float)(this.to - this.from) * progress2);
            ((IMValueInt)this.getTarget()).setValue(newValue);
        }
    }

    private static abstract class Storage {
        private Storage() {
        }

        abstract int get();

        static class Callback
        extends Storage {
            IntSupplier callback;

            public Callback(IntSupplier callback) {
                this.callback = callback;
            }

            @Override
            int get() {
                return this.callback.getAsInt();
            }
        }

        static class Fixed
        extends Storage {
            int value;

            public Fixed(int value) {
                this.value = value;
            }

            @Override
            int get() {
                return this.value;
            }
        }
    }
}

