/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.features;

import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.api.FeatureBase;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.api.os3.ISpawnEntry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class PrecisionGenerator
extends FeatureBase
implements IFeature {
    private PrecisionGenerator(Random rand) {
        super(rand);
    }

    public PrecisionGenerator() {
        this(new Random());
    }

    @Override
    public void generate(World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, ISpawnEntry spawnData, ChunkPos posIn) {
        int nodeSize;
        ChunkPos pos = posIn;
        JsonObject params = spawnData.getFeature().getFeatureParameters();
        int chunkX = pos.field_77276_a;
        int chunkZ = pos.field_77275_b;
        PrecisionGenerator.mergeDefaults(params, this.getDefaultParameters());
        this.runCache(chunkX, chunkZ, world, spawnData);
        int nodeCount = params.get("numObjects").getAsInt();
        int maxHeight = params.get("maxHeight").getAsInt();
        int minHeight = params.get("minHeight").getAsInt();
        int thisNode = nodeSize = params.get("size").getAsInt();
        for (int c = nodeCount; c > 0; --c) {
            HeightRange hr = new HeightRange(minHeight, maxHeight);
            BlockPos spot = this.chooseSpot(chunkX, chunkZ, hr);
            int sc = this.spawnAtSpot(thisNode, hr, spot, new ChunkPos(chunkX, chunkZ), spawnData, world);
            if (sc != thisNode && sc != 0) {
                thisNode += nodeSize - sc;
            } else if (sc == thisNode) {
                thisNode = nodeSize;
            }
            if (thisNode > 0) continue;
            thisNode = nodeSize;
        }
    }

    private int spawnAtSpot(int nodeSize, HeightRange heightRange, BlockPos spot, ChunkPos pos, ISpawnEntry spawnData, World world) {
        int c;
        int spawned = 0;
        BlockPos act = spot;
        for (int counter = nodeSize; counter > 0 && spawned < nodeSize; counter -= c + 1, spawned += c) {
            c = this.spawnOreNode(act, pos, spawnData, world, nodeSize, heightRange);
            if (c != 0) continue;
            act = this.chooseSpot(Math.floorDiv(spot.func_177958_n(), 16), Math.floorDiv(spot.func_177952_p(), 16), heightRange);
        }
        return spawned;
    }

    private int spawnOreNode(BlockPos loc, ChunkPos pos, ISpawnEntry spawnData, World world, int nodeSize, HeightRange heightRange) {
        int lutType = nodeSize < 8 ? offsetIndexRef_small.length : offsetIndexRef.length;
        int[] lut = nodeSize < 8 ? offsetIndexRef_small : offsetIndexRef;
        Vec3i[] offs = new Vec3i[lutType];
        System.arraycopy(nodeSize < 8 ? offsets_small : offsets, 0, offs, 0, lutType);
        if (nodeSize < 27) {
            int[] scrambledLUT = new int[lutType];
            System.arraycopy(lut, 0, scrambledLUT, 0, scrambledLUT.length);
            this.scramble(scrambledLUT, this.random);
            int nc = 0;
            for (int count = nodeSize; count > 0 && nc <= nodeSize; --count) {
                int dimension;
                Vec3i offset;
                BlockPos p;
                IBlockState oreBlock = spawnData.getBlocks().getRandomBlock(this.random);
                if (!this.spawn(oreBlock, world, p = this.fixMungeOffset(offset = offs[scrambledLUT[--count]], loc, heightRange, pos), dimension = world.field_73011_w.getDimension(), true, spawnData)) continue;
                ++nc;
            }
            return nc;
        }
        return this.spawnFill(spawnData, world, pos, loc, nodeSize, heightRange);
    }

    private BlockPos fixMungeOffset(Vec3i offset, BlockPos spot, HeightRange heightRange, ChunkPos pos) {
        BlockPos p = spot.func_177971_a(offset);
        ChunkPos x1z1 = new ChunkPos(pos.field_77276_a + 1, pos.field_77275_b + 1);
        int xMax = x1z1.func_180332_e();
        int zMax = x1z1.func_180330_f();
        int xMin = pos.func_180334_c();
        int zMin = pos.func_180333_d();
        int xmod = offset.func_177958_n();
        int ymod = offset.func_177956_o();
        int zmod = offset.func_177952_p();
        if (p.func_177956_o() < heightRange.getMin() || p.func_177956_o() > heightRange.getMax()) {
            ymod = this.rescaleOffset(ymod, spot.func_177956_o(), heightRange.getMin(), heightRange.getMax());
        }
        if (p.func_177958_n() < xMin || p.func_177958_n() > xMax) {
            xmod = this.rescaleOffset(xmod, spot.func_177958_n(), xMin, xMax);
        }
        if (p.func_177952_p() < zMin || p.func_177952_p() > zMax) {
            zmod = this.rescaleOffset(zmod, spot.func_177952_p(), zMin, zMax);
        }
        return spot.func_177982_a(xmod, ymod, zmod);
    }

    private int rescaleOffset(int offsetIn, int centerIn, int minimumIn, int maximumIn) {
        int actual = centerIn + offsetIn;
        int range = maximumIn - minimumIn;
        int wrapDistance = actual < minimumIn ? minimumIn - actual : actual - maximumIn;
        wrapDistance = wrapDistance < 0 ? -1 * wrapDistance % range : (wrapDistance %= range);
        int workingPoint = actual < minimumIn ? maximumIn - wrapDistance : minimumIn + wrapDistance;
        return workingPoint - centerIn;
    }

    private int spawnFill(ISpawnEntry spawnData, World world, ChunkPos pos, BlockPos loc, int nodeSize, HeightRange heightRange) {
        double radius = Math.pow(nodeSize, 0.3333333333333333) * 0.238732414637843 + 2.0;
        int rSqr = (int)Math.ceil(radius * radius);
        return this.spawnPrecise(spawnData, world, pos, loc, heightRange, !this.random.nextBoolean(), radius, rSqr, nodeSize);
    }

    private int spawnPrecise(ISpawnEntry spawnData, World world, ChunkPos pos, BlockPos loc, HeightRange heightRange, boolean toPositive, double radius, int rSqr, int nodeSize) {
        int quantity = nodeSize;
        int nc = 0;
        int dy = (int)(-1.0 * radius);
        while ((double)dy < radius) {
            int dx = this.getStart(toPositive, radius);
            while (this.endCheck(toPositive, dx, radius)) {
                int dz = this.getStart(toPositive, radius);
                while (this.endCheck(toPositive, dz, radius)) {
                    if (this.doCheckSpawn(dx, dy, dz, rSqr, heightRange, spawnData, world, pos, loc) >= 0 && (++nc >= nodeSize || --quantity <= 0)) {
                        return nc;
                    }
                    dz = this.countItem(dz, toPositive);
                }
                dx = this.countItem(dx, toPositive);
            }
            ++dy;
        }
        return nc;
    }

    private int doCheckSpawn(int dx, int dy, int dz, int rSqr, HeightRange heightRange, ISpawnEntry spawnData, World world, ChunkPos pos, BlockPos loc) {
        if (this.getABC(dx, dy, dz) <= rSqr) {
            BlockPos p = this.fixMungeOffset(new Vec3i(dx, dy, dz), loc, heightRange, pos);
            IBlockState bl = spawnData.getBlocks().getRandomBlock(this.random);
            if (bl.func_177230_c().equals(Blocks.field_150350_a)) {
                return -1;
            }
            return this.spawn(bl, world, p, world.field_73011_w.getDimension(), true, spawnData) ? 1 : 0;
        }
        return -1;
    }

    private int getPoint(int lowerBound, int upperBound) {
        ArrayList<Integer> arr = new ArrayList<Integer>();
        for (int i = lowerBound; i <= upperBound; ++i) {
            arr.add(i);
        }
        return (Integer)arr.get(this.random.nextInt(arr.size()));
    }

    private BlockPos chooseSpot(int xPosition, int zPosition, HeightRange heightRange) {
        int xRet = this.getPoint(0, 15) + xPosition * 16;
        int zRet = this.getPoint(0, 15) + zPosition * 16;
        int yRet = this.getPoint(heightRange.getMin(), heightRange.getMax());
        return new BlockPos(xRet, yRet, zRet);
    }

    @Override
    public void setRandom(Random rand) {
        this.random = rand;
    }

    @Override
    public JsonObject getDefaultParameters() {
        JsonObject defaults = new JsonObject();
        defaults.addProperty("numObjects", (Number)4);
        defaults.addProperty("minHeight", (Number)16);
        defaults.addProperty("maxHeight", (Number)80);
        defaults.addProperty("size", (Number)8);
        return defaults;
    }

    private class HeightRange {
        private int min;
        private int max;

        HeightRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        int getMin() {
            return this.min;
        }

        int getMax() {
            return this.max;
        }
    }
}

