/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.blocks;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidTank
implements IFluidTank,
IFluidHandler,
IFluidTankProperties {
    protected FluidStack fluid;
    protected int capacity;
    protected TileEntity containerTile;
    protected IFluidTankProperties[] tankProperties = new IFluidTankProperties[]{this};

    public FluidTank(TileEntity tile, int capacity) {
        this(tile, null, capacity);
    }

    public FluidTank(TileEntity tile, FluidStack stack, int capacity) {
        this.containerTile = tile;
        this.setCapacity(capacity);
        this.setFluid(stack);
    }

    public FluidTank(TileEntity tile, Fluid fluid, int amount, int capacity) {
        this(tile, new FluidStack(fluid, amount), capacity);
    }

    public FluidTank readFromNBT(NBTTagCompound nbt) {
        this.setCapacity(nbt.func_74762_e("Capacity"));
        FluidStack loadedFluid = nbt.func_74764_b("Empty") ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        this.setFluid(loadedFluid);
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Capacity", this.capacity);
        if (this.fluid != null) {
            this.fluid.writeToNBT(nbt);
        } else {
            nbt.func_74778_a("Empty", "");
        }
        return nbt;
    }

    public void setFluid(FluidStack fluid) {
        if (fluid != null) {
            fluid.amount = Math.min(fluid.amount, this.capacity);
        }
        this.fluid = fluid;
    }

    public void setCapacity(int capacity) {
        int n = this.capacity = capacity >= 0 ? capacity : 0;
        if (this.fluid != null) {
            this.fluid.amount = Math.min(this.capacity, this.fluid.amount);
        }
    }

    public int getRemainingCapacity() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public boolean isFull() {
        return this.getRemainingCapacity() == 0;
    }

    @Nullable
    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid != null ? this.fluid.amount : 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack fillFluid, boolean doFill) {
        if (fillFluid == null || fillFluid.amount <= 0) {
            return 0;
        }
        if (this.fluid == null) {
            if (!doFill) {
                return Math.min(this.capacity, fillFluid.amount);
            }
            this.fluid = new FluidStack(fillFluid, Math.min(this.capacity, fillFluid.amount));
            if (this.containerTile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluid, this.containerTile.func_145831_w(), this.containerTile.func_174877_v(), (IFluidTank)this, this.fluid.amount));
            }
            return this.fluid.amount;
        }
        if (!this.fluid.isFluidEqual(fillFluid)) {
            return 0;
        }
        int fillAmount = Math.min(this.capacity - this.fluid.amount, fillFluid.amount);
        if (doFill && fillAmount > 0) {
            this.fluid.amount += fillAmount;
            if (this.containerTile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluid, this.containerTile.func_145831_w(), this.containerTile.func_174877_v(), (IFluidTank)this, fillAmount));
            }
        }
        return fillAmount;
    }

    @Nullable
    public FluidStack drain(int drainAmount, boolean doDrain) {
        if (this.fluid == null || drainAmount <= 0) {
            return null;
        }
        if (this.fluid.amount < drainAmount) {
            drainAmount = this.fluid.amount;
        }
        FluidStack drainedFluid = new FluidStack(this.fluid, drainAmount);
        if (doDrain) {
            this.fluid.amount -= drainAmount;
            if (this.fluid.amount == 0) {
                this.fluid = null;
            }
            if (this.containerTile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluid, this.containerTile.func_145831_w(), this.containerTile.func_174877_v(), (IFluidTank)this, drainAmount));
            }
        }
        return drainedFluid;
    }

    @Nullable
    public FluidStack getContents() {
        return this.fluid == null ? null : this.fluid.copy();
    }

    public boolean canFill() {
        return true;
    }

    public boolean canDrain() {
        return true;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return true;
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return true;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tankProperties;
    }

    @Nullable
    public FluidStack drain(FluidStack fluidToDrain, boolean doDrain) {
        if (fluidToDrain == null || this.fluid == null || !fluidToDrain.isFluidEqual(this.fluid)) {
            return null;
        }
        return this.drain(fluidToDrain.amount, doDrain);
    }
}

