/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei.cauldron.ingredient;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.plugins.jei.cauldron.ingredient.PotionIngredient;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public enum PotionIngredientHelper implements IIngredientHelper<PotionIngredient>
{
    INSTANCE;

    public static final List<PotionIngredient> ALL_POTIONS;

    public List<PotionIngredient> expandSubtypes(List<PotionIngredient> ingredients) {
        return ingredients;
    }

    public PotionIngredient getMatch(Iterable<PotionIngredient> ingredients, PotionIngredient match) {
        for (PotionIngredient potion : ingredients) {
            if (potion.getPotion() != match.getPotion()) continue;
            return potion;
        }
        return null;
    }

    public String getDisplayName(PotionIngredient potion) {
        return Util.translate(potion.getPotion().func_185174_b("potion.effect."), new Object[0]);
    }

    public String getUniqueId(PotionIngredient potion) {
        return potion.getPotion().getRegistryName().toString();
    }

    public String getWildcardId(PotionIngredient potion) {
        return this.getUniqueId(potion);
    }

    public String getModId(PotionIngredient potion) {
        return potion.getPotion().getRegistryName().func_110624_b();
    }

    public Iterable<Color> getColors(PotionIngredient potion) {
        return ImmutableList.of((Object)new Color(PotionUtils.func_185183_a((PotionType)potion.getPotion())));
    }

    public String getResourceId(PotionIngredient potion) {
        return potion.getPotion().getRegistryName().func_110623_a();
    }

    public PotionIngredient copyIngredient(PotionIngredient potion) {
        return potion;
    }

    public String getErrorInfo(PotionIngredient potion) {
        return potion == null || potion.getPotion() == null ? "null" : this.getUniqueId(potion);
    }

    public ItemStack getCheatItemStack(PotionIngredient potion) {
        return PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potion.getPotion());
    }

    static {
        ALL_POTIONS = Config.enableCauldronPotions ? StreamSupport.stream(PotionType.field_185176_a.spliterator(), false).filter(type -> type != PotionTypes.field_185229_a && type != PotionTypes.field_185230_b).map(PotionIngredient::new).collect(Collectors.toList()) : Collections.emptyList();
    }
}

