/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.vecmath;

import com.enderio.core.common.vecmath.Vector2d;
import com.enderio.core.common.vecmath.Vector2f;

public class Vector2i {
    public int x;
    public int y;

    public Vector2i() {
        this.x = 0;
        this.y = 0;
    }

    public Vector2i(double x, double y) {
        this.x = (int)x;
        this.y = (int)y;
    }

    public Vector2i(float x, float y) {
        this.x = (int)x;
        this.y = (int)y;
    }

    public Vector2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vector2i(Vector2d other) {
        this(other.x, other.y);
    }

    public Vector2i(Vector2f other) {
        this(other.x, other.y);
    }

    public void set(double x, double y) {
        this.x = (int)x;
        this.y = (int)y;
    }

    public void set(float x, float y) {
        this.x = (int)x;
        this.y = (int)y;
    }

    public void set(Vector2i vec) {
        this.x = vec.x;
        this.y = vec.y;
    }

    public void add(Vector2i vec) {
        this.x += vec.x;
        this.y += vec.y;
    }

    public void sub(Vector2i vec) {
        this.x -= vec.x;
        this.y -= vec.y;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public void scale(int s) {
        this.x *= s;
        this.y *= s;
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distanceSquared(Vector2i v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        return dx * dx + dy * dy;
    }

    public double distance(Vector2i v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public String toString() {
        return "Vector2i(" + this.x + ", " + this.y + ")";
    }
}

