/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.compat.jei.base;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;

public class AdvancedRecipeTransferInfo<C extends Container>
implements IRecipeTransferInfo<C> {
    private final Class<C> containerClass;
    private final String recipeCategoryUid;
    private final int recipeSlotStart;
    private final int recipeSlotCount;
    private final int inventorySlotStart;
    private final int inventorySlotCount;
    private final int additionalSlots;

    public AdvancedRecipeTransferInfo(Class<C> containerClass, String recipeCategoryUid, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount, boolean hasAdditionalSlots, int additionalSlots) {
        this.containerClass = containerClass;
        this.recipeCategoryUid = recipeCategoryUid;
        this.recipeSlotStart = recipeSlotStart;
        this.recipeSlotCount = recipeSlotCount;
        this.inventorySlotStart = inventorySlotStart;
        this.inventorySlotCount = inventorySlotCount;
        this.additionalSlots = hasAdditionalSlots ? additionalSlots : 0;
    }

    public AdvancedRecipeTransferInfo(Class<C> containerClass, String recipeCategoryUid, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this(containerClass, recipeCategoryUid, recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount, false, 0);
    }

    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    public String getRecipeCategoryUid() {
        return this.recipeCategoryUid;
    }

    public boolean canHandle(C container) {
        return true;
    }

    public List<Slot> getRecipeSlots(C container) {
        ArrayList list = IntStream.range(this.recipeSlotStart, this.recipeSlotStart + this.recipeSlotCount).mapToObj(arg_0 -> container.func_75139_a(arg_0)).collect(Collectors.toCollection(ArrayList::new));
        return list;
    }

    public List<Slot> getInventorySlots(C container) {
        ArrayList list = IntStream.range(this.inventorySlotStart, this.inventorySlotStart + this.inventorySlotCount + this.additionalSlots).filter(i -> i < container.field_75151_b.size()).mapToObj(arg_0 -> container.func_75139_a(arg_0)).collect(Collectors.toCollection(ArrayList::new));
        return list;
    }
}

