/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.arrows;

import com.sofodev.armorplus.client.utils.ToolTipUtils;
import com.sofodev.armorplus.common.registry.entities.entityarrow.EntityCoalArrow;
import com.sofodev.armorplus.common.registry.entities.entityarrow.EntityEnderDragonArrow;
import com.sofodev.armorplus.common.registry.entities.entityarrow.EntityLapisArrow;
import com.sofodev.armorplus.common.registry.entities.entityarrow.EntityLavaArrow;
import com.sofodev.armorplus.common.registry.entities.entityarrow.EntityModdedArrow;
import com.sofodev.armorplus.common.registry.entities.entityarrow.EntityRedstoneArrow;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum ArrowType {
    COAL(2.0, TextFormatting.GRAY){

        @Override
        public EntityModdedArrow createArrow(World world, EntityLivingBase shooter) {
            return new EntityCoalArrow(world, shooter);
        }
    }
    ,
    LAPIS(3.5, TextFormatting.DARK_AQUA){

        @Override
        public EntityModdedArrow createArrow(World world, EntityLivingBase shooter) {
            return new EntityLapisArrow(world, shooter);
        }
    }
    ,
    REDSTONE(3.5, TextFormatting.DARK_RED){

        @Override
        public EntityModdedArrow createArrow(World world, EntityLivingBase shooter) {
            return new EntityRedstoneArrow(world, shooter);
        }
    }
    ,
    INFUSED_LAVA(5.5, TextFormatting.GOLD){

        @Override
        public EntityModdedArrow createArrow(World world, EntityLivingBase shooter) {
            return new EntityLavaArrow(world, shooter);
        }
    }
    ,
    ENDER_DRAGON(8.5, TextFormatting.DARK_PURPLE){

        @Override
        public EntityModdedArrow createArrow(World world, EntityLivingBase shooter) {
            return new EntityEnderDragonArrow(world, shooter);
        }
    };

    private final String abilityDescription = new TextComponentTranslation("item.armorplus." + this.name().toLowerCase() + "_arrow.ability_desc", new Object[0]).func_150254_d();
    private final double damage;
    private final TextFormatting formatting;

    private ArrowType(double damage, TextFormatting formatting) {
        this.damage = damage;
        this.formatting = formatting;
    }

    public String getAbilityDescription() {
        return this.abilityDescription;
    }

    public double getDamage() {
        return this.damage;
    }

    public TextFormatting getFormatting() {
        return this.formatting;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getItemArrowName() {
        return this.getName() + "_arrow";
    }

    public abstract EntityModdedArrow createArrow(World var1, EntityLivingBase var2);

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> tooltip) {
        ToolTipUtils.addArrowInformation(tooltip, this.getAbilityDescription(), this.getDamage(), this.getFormatting());
    }
}

