/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.Ic2Crops;
import ic2.core.block.crop.TileEntityCrop;
import ic2.core.block.crop.crops.CropCardBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropNetherWart
extends CropCardBase {
    public CropNetherWart() {
        super(new CropProperties(5, 4, 2, 0, 2, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        return this.getSprite("bc")[36 + state];
    }

    @Override
    public String getDiscoveredBy() {
        return "Notch";
    }

    @Override
    public String getId() {
        return "NetherWart";
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Red", "Nether", "Ingredient", "Soulsand"};
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 3;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 3;
    }

    @Override
    public int getMaxSize() {
        return 3;
    }

    @Override
    public double dropGainChance() {
        return 2.0;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Items.field_151075_bm);
    }

    @Override
    public void tick(ICropTile cropTile) {
        if (cropTile.isBlockBelow(Blocks.field_150425_aM)) {
            if (this.canGrow(cropTile) && cropTile instanceof TileEntityCrop) {
                TileEntityCrop crop = (TileEntityCrop)cropTile;
                crop.setGrowthPoints(crop.getGrowthPoints() + crop.calculateGrowth() / 2);
            }
        } else if (cropTile.isBlockBelow(Blocks.field_150433_aE) && this.getWorld((ICropTile)cropTile).field_73012_v.nextInt(300) == 0) {
            cropTile.setCrop(Ic2Crops.cropTerraWart);
        }
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 3;
    }
}

