/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.transport.transporter;

import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.transport.transporter.BaseTransporter;
import ic2.core.util.misc.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilityTransporter
extends BaseTransporter {
    ICapabilityProvider prov;

    public CapabilityTransporter(ICapabilityProvider cap) {
        super(false);
        this.prov = cap;
    }

    @Override
    public ItemStack removeItem(IFilter filter, EnumFacing dir, int amount, boolean doRemove) {
        IItemHandler inv = this.getHandler(dir);
        if (inv == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ItemStack.field_190927_a;
        int slots = inv.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack removed;
            int toRemove;
            ItemStack invItem = inv.getStackInSlot(i);
            if (invItem == null || !filter.matches(invItem) || !stack.func_190926_b() && !this.canMerge(stack, invItem) || (toRemove = Math.min(invItem.func_190916_E(), amount - stack.func_190916_E())) <= 0 || (removed = inv.extractItem(i, toRemove, !doRemove)).func_190926_b()) continue;
            if (stack.func_190926_b()) {
                stack = removed;
            } else {
                stack.func_190917_f(removed.func_190916_E());
            }
            if (stack.func_190916_E() >= amount) break;
        }
        return stack;
    }

    @Override
    public int injectItem(ItemStack stack, EnumFacing dir, boolean doAdd) {
        IItemHandler inv = this.getHandler(dir);
        if (inv == null) {
            return 0;
        }
        int alreadyAdded = 0;
        int slots = inv.getSlots();
        int maxItemSize = stack.func_77976_d();
        for (int i = 0; i < slots; ++i) {
            ItemStack added;
            int toAdd;
            ItemStack invItem = inv.getStackInSlot(i);
            if (invItem.func_190926_b()) {
                toAdd = stack.func_190916_E() - alreadyAdded;
                if (toAdd > 0) {
                    added = inv.insertItem(i, StackUtil.copyWithSize(stack, toAdd), !doAdd);
                    alreadyAdded += toAdd - added.func_190916_E();
                }
            } else if (this.canMerge(stack, invItem) && (toAdd = Math.min(stack.func_190916_E() - alreadyAdded, maxItemSize - invItem.func_190916_E())) > 0) {
                added = inv.insertItem(i, StackUtil.copyWithSize(stack, toAdd), !doAdd);
                alreadyAdded += toAdd - added.func_190916_E();
            }
            if (alreadyAdded >= stack.func_190916_E()) break;
        }
        return alreadyAdded;
    }

    @Override
    public int getSizeInventory(EnumFacing side) {
        IItemHandler handler = this.getHandler(side);
        return handler != null ? handler.getSlots() : 0;
    }

    @Override
    public void markInventoryDirty() {
    }

    public IItemHandler getHandler(EnumFacing side) {
        if (this.prov.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)this.prov.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        return null;
    }
}

