/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.api.classic.network.adv.NetworkField;
import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.buffers.OutputBuffer;
import ic2.core.network.packets.IC2Packet;
import ic2.core.platform.player.TeamManager;
import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class TeamUpdatePacket
extends IC2Packet {
    Map<UUID, String> teamData = new LinkedHashMap<UUID, String>();

    public TeamUpdatePacket() {
    }

    public TeamUpdatePacket(Map<UUID, String> data) {
        this.teamData.putAll(data);
    }

    @Override
    public void read(ByteBuf par1) {
        InputBuffer buffer = new InputBuffer(par1);
        int expected = buffer.readShort();
        for (int i = 0; i < expected; ++i) {
            UUID id = buffer.readUUID();
            String name = buffer.readString(NetworkField.BitLevel.Bit16);
            this.teamData.put(id, name);
        }
    }

    @Override
    public void write(ByteBuf par1) {
        OutputBuffer buffer = new OutputBuffer(par1);
        buffer.writeShort((short)this.teamData.size());
        for (Map.Entry<UUID, String> entry : this.teamData.entrySet()) {
            buffer.writeUUID(entry.getKey());
            buffer.writeString(entry.getValue(), NetworkField.BitLevel.Bit16);
        }
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        TeamManager.instance.onClientUpdate(this.teamData);
    }
}

