/*
 * Decompiled with CFR 0.152.
 */
package hqbanana.skycompression.plugins.crafttweaker;

import com.bartz24.skyresources.recipe.ProcessRecipe;
import com.bartz24.skyresources.recipe.ProcessRecipeManager;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;

public class MTRecipeBase {
    public static void addRecipe(ProcessRecipe recipe, ProcessRecipeManager type) {
        CraftTweakerAPI.apply((IAction)new AddSkyResourcesRecipe(recipe, type));
    }

    public static void removeRecipe(ProcessRecipe recipe, ProcessRecipeManager type) {
        CraftTweakerAPI.apply((IAction)new RemoveSkyResourcesRecipe(recipe, type));
    }

    public static class RemoveSkyResourcesRecipe
    implements IAction {
        private final ProcessRecipe recipe;
        private final ProcessRecipeManager recipeType;

        public RemoveSkyResourcesRecipe(ProcessRecipe recipe, ProcessRecipeManager recipeType) {
            this.recipe = recipe;
            this.recipeType = recipeType;
        }

        public void apply() {
            this.recipeType.removeCTRecipe(this.recipe);
        }

        public String describe() {
            return "Removing Sky Resources recipe for " + (this.recipe.getOutputs().size() > 0 ? this.recipe.getOutputs().get(0) : (this.recipe.getFluidOutputs().size() > 0 ? this.recipe.getFluidOutputs().get(0) : "NULL"));
        }
    }

    private static class AddSkyResourcesRecipe
    implements IAction {
        private final ProcessRecipe recipe;
        private final ProcessRecipeManager recipeType;

        public AddSkyResourcesRecipe(ProcessRecipe recipe, ProcessRecipeManager type) {
            this.recipe = recipe;
            this.recipeType = type;
        }

        public void apply() {
            this.recipeType.addCTRecipe(this.recipe);
        }

        public String describe() {
            return "Adding Sky Resources recipe for " + (this.recipe.getOutputs().size() > 0 ? this.recipe.getOutputs().get(0) : (this.recipe.getFluidOutputs().size() > 0 ? this.recipe.getFluidOutputs().get(0) : "NULL"));
        }
    }
}

